% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plurality_method.R
\name{plurality_method}
\alias{plurality_method}
\title{Plurality Method to Find Absolute or Relative Majority}
\usage{
plurality_method(x, allow_dup = TRUE, min_valid = 1)
}
\arguments{
\item{x}{an object of class \code{vote}.}

\item{allow_dup}{whether ballots with duplicated score values 
are taken into account. Default is TRUE.}

\item{min_valid}{default is 1. If the number of valid entries of 
a ballot is less than this value, the ballot will not be used.}
}
\value{
a list object.
\itemize{
  \item (1) \code{call} the function call.
  \item (2) \code{method} the counting method.
  \item (3) \code{candidate} candidate names.
  \item (4) \code{candidate_num} number of candidate.
  \item (5) \code{ballot_num} number of ballots in x.
  \item (6) \code{valid_ballot_num} number of ballots that are 
used to compute the result.
  \item (7) \code{winner} the winners, may be one, more than one or NULL.
  \item (8) \code{absolute} whether the winner is of absolute majority.
  \item (9) \code{other_info} a list with 2 elements, the 1st is the 
frequencies of candidates mentioned as 1st choice; the second element is 
the percentage. If winner is NULL, these two are NULL.
}
}
\description{
Although with plurality method each voter is required to mention 
only one candidate, a ballot with more than one candidate and 
different scores is also valid. For a score matrix, the function will 
check the position j which has the lowest score (in a \code{vote} object, 
the lower, the better) in the ith row. Duplicated values may or may 
not be a problem. For instance, \code{c(2, 3, 3)} is valid, for the 
lowest value is 2 and it is in the 1st position. However, 
\code{c(2, 2, 3)} is a problem, for the 1st and 2nd positions 
all have the lowest value 2. If this problem exists, the winner 
returned by this function will be NULL.
}
\examples{
raw <- rbind(
    c(1, 2, 5, 3, 3), c(1, 2, 5, 3, 4), c(1, 2, 5, 3, 4), 
    c(NA, NA, NA, NA, NA), c(NA, 3, 5, 1, 2), 
    c(NA, NA, NA, 2, 3), c(NA, NA, 1, 2, 3), 
    c(NA, NA, NA, NA, 2), c(NA, NA, NA, 2, 2), 
    c(NA, NA, 1, 1, 2), c(1, 1, 5, 5, NA)
)
vote <- create_vote(raw, xtype = 1)
y <- plurality_method(vote, allow_dup = FALSE)
y <- plurality_method(vote, allow_dup=FALSE, min_valid = 3)
}
