% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWLS.R
\name{PWLS}
\alias{PWLS}
\title{Penalized weighted least-squares estimate for variable selection on correlated multiply imputed data}
\usage{
PWLS(
  missdata,
  mice_time = 5,
  penalty = "alasso",
  lamda.vec = seq(6, 24, length.out = 40),
  Gamma = c(0.5, 1, 2)
)
}
\arguments{
\item{missdata}{A Matrix,missing data with variables X in the first p columns and response Y at the last column.}

\item{mice_time}{An intedevger, number of imputation.}

\item{penalty}{The method for variable selection,choose from "lasso" or "alasso".}

\item{lamda.vec}{Optimal tuning parameter for penalty,default seq(1,4,length.out=12).}

\item{Gamma}{Parameter for adjustment of the Adaptive Weights vector in adaptive LASSO,default c(0.5,1,1.5).}
}
\value{
A Vsmi_est object, contians estcoef and index_sig , estcoef for estimate coefficients and index_sig for selected variable index.
}
\description{
This is a functions to estimate coefficients of wighted leat-squares model and
select variables for multiple imputed data sets
,considering the correlation of multiple imputed observations.
}
\examples{
\donttest{
library(MASS)
library(mice)
library(qif)
entire<-generate_pwls_missing_data()
est_lasso<-PWLS(entire,penalty="lasso")
est_alasso <- PWLS(entire,penalty = "alasso")
}
}
