% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{html_dependency_vue3}
\alias{html_dependency_vue3}
\title{Dependencies for 'Vue3'}
\usage{
html_dependency_vue3(offline = TRUE, minified = TRUE)
}
\arguments{
\item{offline}{\code{logical} to use local file dependencies.  If \code{FALSE},
then the dependencies use cdn as its \code{src}.}

\item{minified}{\code{logical} to use minified (production) version.  Use
\code{minified = FALSE} for debugging or working with Vue devtools.}
}
\value{
\code{\link[htmltools]{htmlDependency}}
}
\description{
Dependencies for 'Vue3'
}
\examples{
if(interactive()){

library(vueR)
library(htmltools)

browsable(
  tagList(
    tags$div(id="app","{{message}}"),
    tags$script(
    "
    var app = {
      data: function() {
        return {
          message: 'Hello Vue!'
        }
      }
    };

    Vue.createApp(app).mount('#app');
    "
    ),
    html_dependency_vue3()
  )
)
}
}
\seealso{
Other dependencies: 
\code{\link{html_dependency_vue}()}
}
\concept{dependencies}
