% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_current_datetime_column.R
\name{add_current_datetime_column}
\alias{add_current_datetime_column}
\title{Add current date and time to data frame.}
\usage{
add_current_datetime_column(data)
}
\arguments{
\item{data}{Data frame.}
}
\value{
Data frame with an additional column containing the current date and time.
}
\description{
This function adds a new column to a data frame with the current date and time.
The name of the new column is a combination of the provided prefix, stage, and "Date_time".
If the new column already exists, it will be overwritten.
}
\examples{
\dontrun{
# Create a sample data frame
data <- data.frame(a = 1:5, b = letters[1:5])

# Add date to file name
add_current_datetime_column(data)
}
}
