% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wNNSel.impute.R
\name{wNNSel.impute}
\alias{wNNSel.impute}
\title{Weighted Nearest Neighbor Imputation of Missing Values using Selected Variables}
\usage{
wNNSel.impute(x, k, useAll = TRUE, x.initial = NULL, x.dist = "euclidean",
  kernel = "gaussian", lambda = 0.3, impute.fn, convex = TRUE,
  method = "2", m = 2, c = 0.3, withinFolds = FALSE, folds,
  verbose = TRUE, verbose2 = FALSE)
}
\arguments{
\item{x}{a \code{matrix} containing missing values}

\item{k}{an optional, the number of nearest neighbors to use for imputation.}

\item{useAll}{\code{logical}. The default is \code{useALL=TRUE}, that is, all \emph{available} neighbors are used for the imputation.}

\item{x.initial}{an optional. A complete data matrix e.g. using mean imputation of \code{x}. If provided, it will be used for the computation of correlations.}

\item{x.dist}{distance to compute. The default is \code{x.dist="euclidean"}, that uses the Euclidean distance. Set \code{x.dist} to \code{NULL} for Manhattan distance.}

\item{kernel}{kernel function to be used in nearest neighbors imputation. Default kernel function is "gaussian".}

\item{lambda}{\code{scaler}, a tuning parameter}

\item{impute.fn}{the imputation function to run on the length k vector of values for a missing feature. 
Defaults to a weighted mean of the neighboring values, weighted by the specified \code{kernel}. If not specified then wNN imputation will be used by default.}

\item{convex}{logical. If \code{TRUE}, selected variables are used for the computation of distance.  The default is \code{TRUE}.}

\item{method}{convex function,  performs selection of variables. If \code{method="1"}, linear function is used and the power function is used when \code{method="2"}.}

\item{m}{\code{scaler}, a tuning parameter required by the power function.}

\item{c}{\code{scaler}, a tuning parameter required by the linear function.}

\item{withinFolds}{\code{logical}. Use only if the neighbors/rows belong to particular folds/groups. Default is set to \code{FALSE}.}

\item{folds}{a \code{list} of vectors specifying folds/groups for neighbors. lenght of list is equal to the number of folds/groups. 
Each element/vector of the list indicates row indices belonging to that particular group/fold.}

\item{verbose}{logical. If \code{TRUE}, prints status updates}

\item{verbose2}{logical. If \code{TRUE}, prints status updates with more detail}
}
\value{
imputed data matrix
}
\description{
This function imputes the missing values using user-spefied values of the tuning parameters. 
It also works when the samples are smaller than the covariates.
}
\details{
For each sample, identify missinng features.  For each missing feature
find the nearest neighbors which have that feature.  Impute the missing
value using the imputation function on the \emph{selected} vector of values
found from the neighbors.
}
\examples{
  set.seed(3)
  x = matrix(rnorm(100),10,10)
  x.miss = x > 1
  x[x.miss] = NA
  wNNSel.impute(x)
  wNNSel.impute(x, lambda=0.5, m=2)
}
\seealso{
\code{\link{cv.wNNSel}},  \code{\link{wNNSel}}
}
\keyword{NA}
\keyword{wNNSel}
\keyword{weights}

