% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_generation.R
\name{create_accessibility_report}
\alias{create_accessibility_report}
\title{Create Comprehensive Accessibility Report}
\usage{
create_accessibility_report(
  input,
  api_key = NULL,
  output_dir = NULL,
  report_type = 1,
  include_plots = TRUE,
  custom_theme = "light"
)
}
\arguments{
\item{input}{Character vector. URLs to analyze or paths to JSON files}

\item{api_key}{Character string. WAVE API key (required for URL analysis)}

\item{output_dir}{Character string. Directory to save report files}

\item{report_type}{Integer. WAVE report type (1-4)}

\item{include_plots}{Logical. Whether to include plots in the report (default: TRUE)}

\item{custom_theme}{Character string. Visual theme for plots (default: "light")}
}
\value{
List containing plots and summary data frame
}
\description{
Generates a complete accessibility report with visualizations and summary data
}
\examples{
\dontrun{
report <- create_accessibility_report(
  input = c("https://example.com", "https://example.org"),
  api_key = "your_api_key",
  output_dir = tempdir()
)
}
}
