% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/military.R
\name{military}
\alias{military}
\title{Generate Random Vector of Military Branches}
\usage{
military(
  n,
  x = c("Army", "Air Force", "Navy", "Marine Corps", "Coast Guard"),
  prob = c(0.3785, 0.2334, 0.2218, 0.1366, 0.0296),
  name = "Military"
)
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{x}{A vector of elements to chose from.}

\item{prob}{A vector of probabilities to chose from.}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}
}
\value{
Returns a random factor vector of military branch elements.
}
\description{
Generate a random vector of military branches.
}
\details{
The military branches and probabilities used match approximate U.S.
military make-up:

\tabular{lrr}{
  \bold{ Branch} \tab \bold{N} \tab \bold{Percent} \cr
  Army         \tab 541,291 \tab 37.9\%\cr
  Air Force    \tab 333,772 \tab 23.3\%\cr
  Navy         \tab 317,237 \tab 22.2\%\cr
  Marine Corps \tab 195,338 \tab 13.7\%\cr
  Coast Guard  \tab 42,357  \tab 3.0\%\cr
}
}
\examples{
military(10)
barplot(table(military(10000)))
pie(table(military(10000)))
}
\seealso{
Other variable functions: 
\code{\link{age}()},
\code{\link{animal}()},
\code{\link{answer}()},
\code{\link{area}()},
\code{\link{car}()},
\code{\link{children}()},
\code{\link{coin}()},
\code{\link{color}},
\code{\link{date_stamp}()},
\code{\link{death}()},
\code{\link{dice}()},
\code{\link{dna}()},
\code{\link{dob}()},
\code{\link{dummy}()},
\code{\link{education}()},
\code{\link{employment}()},
\code{\link{eye}()},
\code{\link{grade_level}()},
\code{\link{grade}()},
\code{\link{group}()},
\code{\link{hair}()},
\code{\link{height}()},
\code{\link{income}()},
\code{\link{internet_browser}()},
\code{\link{iq}()},
\code{\link{language}},
\code{\link{level}()},
\code{\link{likert}()},
\code{\link{lorem_ipsum}()},
\code{\link{marital}()},
\code{\link{month}()},
\code{\link{name}},
\code{\link{normal}()},
\code{\link{political}()},
\code{\link{race}()},
\code{\link{religion}()},
\code{\link{sat}()},
\code{\link{sentence}()},
\code{\link{sex_inclusive}()},
\code{\link{sex}()},
\code{\link{smokes}()},
\code{\link{speed}()},
\code{\link{state}()},
\code{\link{string}()},
\code{\link{upper}()},
\code{\link{valid}()},
\code{\link{year}()},
\code{\link{zip_code}()}
}
\concept{variable functions}
\keyword{army}
\keyword{branch}
\keyword{marines}
\keyword{military}
\keyword{navy}
