% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_counterfactual.R
\name{predict_counterfactual}
\alias{predict_counterfactual}
\title{Predictions for walker object}
\usage{
predict_counterfactual(
  object,
  newdata,
  u,
  summary = TRUE,
  type = ifelse(object$distribution == "gaussian", "response", "mean")
)
}
\arguments{
\item{object}{An output from \code{\link[=walker]{walker()}} or \code{\link[=walker_glm]{walker_glm()}}.}

\item{newdata}{A \code{data.frame} containing covariates used for prediction.
Should have equal number of rows as the original data}

\item{u}{For Poisson model, a vector of exposures i.e. E(y) = u\emph{exp(x}beta).
For binomial, a vector containing the number of trials. Defaults 1.}

\item{summary}{If \code{TRUE} (default), return summary statistics. Otherwise returns samples.}

\item{type}{If \code{"response"} (default for Gaussian model), predictions are on the response level
(e.g., number of successes for Binomial case, and for Gaussian case the observational
level noise is added to the mean predictions).
If \code{"mean"} (default for non-Gaussian case), predict means (e.g., success probabilities in Binomial case).
If \code{"link"}, predictions for non-Gaussian models are returned before applying the inverse of the link-function.}
}
\value{
If \code{summary=TRUE}, time series containing summary statistics of predicted values.
Otherwise a matrix of samples from predictive distribution.
}
\description{
Given the new covariate data and output from \code{walker},
obtain samples from posterior predictive distribution for counterfactual case,
i.e. for past time points with different covariate values.
}
\examples{
\dontrun{
set.seed(1)
n <- 50
x1 <- rnorm(n, 0, 1)
x2 <- rnorm(n, 1, 0.5)
x3 <- rnorm(n)
beta1 <- cumsum(c(1, rnorm(n - 1, sd = 0.1)))
beta2 <- cumsum(c(0, rnorm(n - 1, sd = 0.1)))
beta3 <- -1
u <- sample(1:10, size = n, replace = TRUE)
y <- rbinom(n, u, plogis(beta3 * x3 + beta1 * x1 + beta2 * x2))

d <- data.frame(y, x1, x2, x3)
out <- walker_glm(y ~ x3 + rw1(~ -1 + x1 + x2, beta = c(0, 2), 
  sigma = c(2, 10)), distribution = "binomial", beta = c(0, 2), 
  u = u, data = d,
  iter = 2000, chains = 1, refresh = 0)

# what if our covariates were constant?
newdata <- data.frame(x1 = rep(0.4, n), x2 = 1, x3 = -0.1)

fitted <- fitted(out)
pred <- predict_counterfactual(out, newdata, type = "mean")

ts.plot(cbind(fitted[, c(1, 3, 5)], pred[, c(1, 3, 5)]), 
  col = rep(1:2, each = 3), lty = c(1, 2, 2))
}
}
