// Generated by rstantools.  Do not edit by hand.

/*
    walker is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    licence is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with licence.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_walker_lm_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 249> locations_array__ =
  {" (found before start of program)",
  " (in 'string', line 169, column 2 to column 29)",
  " (in 'string', line 170, column 2 to column 39)",
  " (in 'string', line 171, column 2 to column 39)",
  " (in 'string', line 172, column 2 to column 24)",
  " (in 'string', line 175, column 2 to column 20)",
  " (in 'string', line 176, column 2 to column 42)",
  " (in 'string', line 177, column 2 to column 18)",
  " (in 'string', line 178, column 2 to column 15)",
  " (in 'string', line 207, column 2 to column 33)",
  " (in 'string', line 208, column 2 to column 38)",
  " (in 'string', line 209, column 2 to column 37)",
  " (in 'string', line 210, column 2 to column 33)",
  " (in 'string', line 183, column 4 to column 31)",
  " (in 'string', line 182, column 9 to line 184, column 3)",
  " (in 'string', line 181, column 4 to column 36)",
  " (in 'string', line 180, column 19 to line 182, column 3)",
  " (in 'string', line 180, column 2 to line 184, column 3)",
  " (in 'string', line 185, column 2 to column 17)",
  " (in 'string', line 188, column 6 to column 52)",
  " (in 'string', line 187, column 22 to line 189, column 5)",
  " (in 'string', line 187, column 4 to line 189, column 5)",
  " (in 'string', line 191, column 6 to column 56)",
  " (in 'string', line 190, column 22 to line 192, column 5)",
  " (in 'string', line 190, column 4 to line 192, column 5)",
  " (in 'string', line 186, column 17 to line 193, column 3)",
  " (in 'string', line 186, column 2 to line 193, column 3)",
  " (in 'string', line 194, column 2 to column 86)",
  " (in 'string', line 216, column 6 to column 61)",
  " (in 'string', line 215, column 22 to line 217, column 5)",
  " (in 'string', line 215, column 4 to line 217, column 5)",
  " (in 'string', line 219, column 6 to column 69)",
  " (in 'string', line 220, column 6 to column 44)",
  " (in 'string', line 218, column 22 to line 221, column 5)",
  " (in 'string', line 218, column 4 to line 221, column 5)",
  " (in 'string', line 225, column 8 to column 86)",
  " (in 'string', line 224, column 24 to line 226, column 7)",
  " (in 'string', line 224, column 6 to line 226, column 7)",
  " (in 'string', line 228, column 8 to column 67)",
  " (in 'string', line 229, column 8 to column 76)",
  " (in 'string', line 227, column 24 to line 230, column 7)",
  " (in 'string', line 227, column 6 to line 230, column 7)",
  " (in 'string', line 223, column 25 to line 231, column 5)",
  " (in 'string', line 223, column 4 to line 231, column 5)",
  " (in 'string', line 234, column 6 to column 91)",
  " (in 'string', line 233, column 18 to line 235, column 5)",
  " (in 'string', line 233, column 4 to line 235, column 5)",
  " (in 'string', line 238, column 13 to column 14)",
  " (in 'string', line 238, column 16 to column 17)",
  " (in 'string', line 238, column 6 to line 239, column 44)",
  " (in 'string', line 240, column 6 to column 34)",
  " (in 'string', line 241, column 20 to column 49)",
  " (in 'string', line 241, column 6 to column 49)",
  " (in 'string', line 237, column 4 to line 242, column 5)",
  " (in 'string', line 246, column 6 to column 68)",
  " (in 'string', line 247, column 6 to column 60)",
  " (in 'string', line 245, column 18 to line 248, column 5)",
  " (in 'string', line 245, column 4 to line 248, column 5)",
  " (in 'string', line 212, column 17 to line 249, column 3)",
  " (in 'string', line 212, column 2 to line 249, column 3)",
  " (in 'string', line 197, column 2 to column 54)",
  " (in 'string', line 198, column 2 to column 47)",
  " (in 'string', line 199, column 2 to column 53)",
  " (in 'string', line 200, column 2 to column 53)",
  " (in 'string', line 204, column 2 to column 34)",
  " (in 'string', line 103, column 2 to column 23)",
  " (in 'string', line 104, column 2 to column 21)",
  " (in 'string', line 105, column 2 to column 21)",
  " (in 'string', line 106, column 2 to column 17)",
  " (in 'string', line 107, column 2 to column 17)",
  " (in 'string', line 108, column 2 to column 17)",
  " (in 'string', line 109, column 2 to column 21)",
  " (in 'string', line 110, column 9 to column 10)",
  " (in 'string', line 110, column 12 to column 19)",
  " (in 'string', line 110, column 2 to column 32)",
  " (in 'string', line 111, column 9 to column 10)",
  " (in 'string', line 111, column 12 to column 13)",
  " (in 'string', line 111, column 2 to column 23)",
  " (in 'string', line 112, column 9 to column 10)",
  " (in 'string', line 112, column 2 to column 14)",
  " (in 'string', line 113, column 8 to column 9)",
  " (in 'string', line 113, column 2 to column 31)",
  " (in 'string', line 114, column 2 to column 30)",
  " (in 'string', line 115, column 2 to column 29)",
  " (in 'string', line 117, column 2 to column 23)",
  " (in 'string', line 118, column 2 to column 30)",
  " (in 'string', line 119, column 2 to column 21)",
  " (in 'string', line 120, column 2 to column 28)",
  " (in 'string', line 121, column 2 to column 21)",
  " (in 'string', line 122, column 2 to column 28)",
  " (in 'string', line 124, column 2 to column 32)",
  " (in 'string', line 125, column 2 to column 32)",
  " (in 'string', line 126, column 2 to column 31)",
  " (in 'string', line 127, column 2 to column 31)",
  " (in 'string', line 129, column 2 to column 24)",
  " (in 'string', line 130, column 2 to column 22)",
  " (in 'string', line 131, column 9 to column 10)",
  " (in 'string', line 131, column 2 to column 20)",
  " (in 'string', line 132, column 9 to column 14)",
  " (in 'string', line 132, column 16 to column 17)",
  " (in 'string', line 132, column 2 to column 29)",
  " (in 'string', line 133, column 9 to column 14)",
  " (in 'string', line 133, column 16 to column 17)",
  " (in 'string', line 133, column 2 to column 29)",
  " (in 'string', line 137, column 8 to column 36)",
  " (in 'string', line 137, column 2 to column 50)",
  " (in 'string', line 138, column 9 to column 10)",
  " (in 'string', line 138, column 2 to column 15)",
  " (in 'string', line 139, column 9 to column 10)",
  " (in 'string', line 139, column 12 to column 13)",
  " (in 'string', line 139, column 2 to column 42)",
  " (in 'string', line 140, column 9 to column 10)",
  " (in 'string', line 140, column 12 to column 13)",
  " (in 'string', line 140, column 2 to column 52)",
  " (in 'string', line 141, column 9 to column 10)",
  " (in 'string', line 141, column 2 to column 42)",
  " (in 'string', line 144, column 4 to column 15)",
  " (in 'string', line 147, column 8 to column 20)",
  " (in 'string', line 148, column 8 to column 24)",
  " (in 'string', line 146, column 25 to line 149, column 7)",
  " (in 'string', line 146, column 6 to line 149, column 7)",
  " (in 'string', line 145, column 22 to line 150, column 5)",
  " (in 'string', line 145, column 4 to line 150, column 5)",
  " (in 'string', line 143, column 2 to line 151, column 3)",
  " (in 'string', line 153, column 4 to column 67)",
  " (in 'string', line 152, column 16 to line 154, column 3)",
  " (in 'string', line 152, column 2 to line 154, column 3)",
  " (in 'string', line 156, column 4 to column 26)",
  " (in 'string', line 157, column 4 to column 29)",
  " (in 'string', line 155, column 20 to line 158, column 3)",
  " (in 'string', line 155, column 2 to line 158, column 3)",
  " (in 'string', line 160, column 4 to column 26)",
  " (in 'string', line 161, column 4 to column 29)",
  " (in 'string', line 159, column 26 to line 162, column 3)",
  " (in 'string', line 159, column 2 to line 162, column 3)",
  " (in 'string', line 164, column 4 to column 20)",
  " (in 'string', line 165, column 4 to column 23)",
  " (in 'string', line 163, column 22 to line 166, column 3)",
  " (in 'string', line 163, column 2 to line 166, column 3)",
  " (in 'string', line 169, column 9 to column 16)",
  " (in 'string', line 170, column 8 to column 13)",
  " (in 'string', line 171, column 8 to column 13)",
  " (in 'string', line 175, column 9 to column 10)",
  " (in 'string', line 176, column 9 to column 10)",
  " (in 'string', line 176, column 12 to column 13)",
  " (in 'string', line 177, column 9 to column 10)",
  " (in 'string', line 178, column 9 to column 10)",
  " (in 'string', line 207, column 9 to column 25)",
  " (in 'string', line 208, column 9 to column 10)",
  " (in 'string', line 208, column 12 to column 28)",
  " (in 'string', line 209, column 9 to column 14)",
  " (in 'string', line 209, column 16 to column 32)",
  " (in 'string', line 210, column 9 to column 25)",
  " (in 'string', line 9, column 4 to column 23)",
  " (in 'string', line 10, column 4 to column 20)",
  " (in 'string', line 11, column 4 to column 21)",
  " (in 'string', line 12, column 11 to column 12)",
  " (in 'string', line 12, column 4 to column 58)",
  " (in 'string', line 14, column 11 to column 12)",
  " (in 'string', line 14, column 4 to column 21)",
  " (in 'string', line 15, column 11 to column 12)",
  " (in 'string', line 15, column 14 to column 15)",
  " (in 'string', line 15, column 4 to column 24)",
  " (in 'string', line 17, column 4 to column 30)",
  " (in 'string', line 20, column 6 to column 68)",
  " (in 'string', line 32, column 8 to column 19)",
  " (in 'string', line 33, column 8 to column 34)",
  " (in 'string', line 35, column 10 to column 30)",
  " (in 'string', line 34, column 23 to line 36, column 9)",
  " (in 'string', line 34, column 8 to line 36, column 9)",
  " (in 'string', line 31, column 13 to line 37, column 7)",
  " (in 'string', line 23, column 8 to column 59)",
  " (in 'string', line 24, column 15 to column 16)",
  " (in 'string', line 24, column 8 to column 50)",
  " (in 'string', line 25, column 8 to column 29)",
  " (in 'string', line 26, column 8 to column 47)",
  " (in 'string', line 28, column 10 to column 30)",
  " (in 'string', line 27, column 23 to line 29, column 9)",
  " (in 'string', line 27, column 8 to line 29, column 9)",
  " (in 'string', line 30, column 8 to column 57)",
  " (in 'string', line 22, column 26 to line 31, column 7)",
  " (in 'string', line 22, column 6 to line 37, column 7)",
  " (in 'string', line 19, column 19 to line 38, column 5)",
  " (in 'string', line 19, column 4 to line 38, column 5)",
  " (in 'string', line 39, column 4 to column 18)",
  " (in 'string', line 7, column 54 to line 41, column 3)",
  " (in 'string', line 46, column 4 to column 23)",
  " (in 'string', line 47, column 4 to column 20)",
  " (in 'string', line 48, column 4 to column 21)",
  " (in 'string', line 49, column 11 to column 12)",
  " (in 'string', line 49, column 4 to column 21)",
  " (in 'string', line 50, column 11 to column 12)",
  " (in 'string', line 50, column 14 to column 15)",
  " (in 'string', line 50, column 4 to column 24)",
  " (in 'string', line 51, column 11 to column 12)",
  " (in 'string', line 51, column 4 to column 16)",
  " (in 'string', line 52, column 11 to column 12)",
  " (in 'string', line 52, column 4 to column 16)",
  " (in 'string', line 53, column 11 to column 12)",
  " (in 'string', line 53, column 14 to column 15)",
  " (in 'string', line 53, column 4 to column 19)",
  " (in 'string', line 54, column 11 to column 12)",
  " (in 'string', line 54, column 14 to column 19)",
  " (in 'string', line 54, column 4 to column 23)",
  " (in 'string', line 55, column 11 to column 12)",
  " (in 'string', line 55, column 4 to column 19)",
  " (in 'string', line 59, column 6 to column 66)",
  " (in 'string', line 70, column 8 to column 19)",
  " (in 'string', line 71, column 8 to column 34)",
  " (in 'string', line 73, column 10 to column 30)",
  " (in 'string', line 72, column 23 to line 74, column 9)",
  " (in 'string', line 72, column 8 to line 74, column 9)",
  " (in 'string', line 69, column 13 to line 75, column 7)",
  " (in 'string', line 62, column 8 to column 57)",
  " (in 'string', line 63, column 8 to column 48)",
  " (in 'string', line 64, column 8 to column 36)",
  " (in 'string', line 65, column 8 to column 58)",
  " (in 'string', line 67, column 10 to column 30)",
  " (in 'string', line 66, column 23 to line 68, column 9)",
  " (in 'string', line 66, column 8 to line 68, column 9)",
  " (in 'string', line 61, column 44 to line 69, column 7)",
  " (in 'string', line 61, column 6 to line 75, column 7)",
  " (in 'string', line 57, column 19 to line 76, column 5)",
  " (in 'string', line 57, column 4 to line 76, column 5)",
  " (in 'string', line 78, column 4 to column 33)",
  " (in 'string', line 80, column 6 to column 25)",
  " (in 'string', line 81, column 13 to column 14)",
  " (in 'string', line 81, column 6 to column 31)",
  " (in 'string', line 87, column 8 to column 26)",
  " (in 'string', line 86, column 13 to line 88, column 7)",
  " (in 'string', line 83, column 15 to column 16)",
  " (in 'string', line 83, column 8 to column 44)",
  " (in 'string', line 84, column 8 to column 30)",
  " (in 'string', line 85, column 8 to column 71)",
  " (in 'string', line 82, column 43 to line 86, column 7)",
  " (in 'string', line 82, column 6 to line 88, column 7)",
  " (in 'string', line 79, column 20 to line 89, column 5)",
  " (in 'string', line 79, column 4 to line 89, column 5)",
  " (in 'string', line 91, column 4 to column 17)",
  " (in 'string', line 92, column 4 to column 27)",
  " (in 'string', line 94, column 13 to column 14)",
  " (in 'string', line 94, column 6 to column 30)",
  " (in 'string', line 95, column 13 to column 14)",
  " (in 'string', line 95, column 6 to column 29)",
  " (in 'string', line 96, column 6 to column 41)",
  " (in 'string', line 93, column 19 to line 97, column 5)",
  " (in 'string', line 93, column 4 to line 97, column 5)",
  " (in 'string', line 98, column 4 to column 23)",
  " (in 'string', line 44, column 53 to line 99, column 3)"};
template <typename T0__, typename T2__, typename T3__, typename T4__,
          typename T5__, typename T6__, typename T7__, typename T8__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>,
                              stan::is_eigen_matrix_dynamic<T3__>,
                              stan::is_vt_not_complex<T3__>,
                              stan::is_stan_scalar<T4__>,
                              stan::is_eigen_matrix_dynamic<T5__>,
                              stan::is_vt_not_complex<T5__>,
                              stan::is_eigen_matrix_dynamic<T6__>,
                              stan::is_vt_not_complex<T6__>,
                              stan::is_eigen_matrix_dynamic<T7__>,
                              stan::is_vt_not_complex<T7__>,
                              stan::is_col_vector<T8__>,
                              stan::is_vt_not_complex<T8__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>,
                stan::base_type_t<T2__>, stan::base_type_t<T3__>, T4__,
                stan::base_type_t<T5__>,
                stan::promote_args_t<stan::base_type_t<T6__>,
                  stan::base_type_t<T7__>, stan::base_type_t<T8__>>>,-1,1>
gaussian_filter(const T0__& y_arg__, const std::vector<int>& y_miss,
                const T2__& a1_arg__, const T3__& P1_arg__, const T4__& Ht,
                const T5__& Tt_arg__, const T6__& Rt_arg__, const T7__&
                xreg_arg__, const T8__& gamma2_y_arg__, std::ostream*
                pstream__);
template <typename T0__, typename T2__, typename T3__, typename T4__,
          typename T5__, typename T6__, typename T7__, typename T8__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>,
                              stan::is_eigen_matrix_dynamic<T3__>,
                              stan::is_vt_not_complex<T3__>,
                              stan::is_stan_scalar<T4__>,
                              stan::is_eigen_matrix_dynamic<T5__>,
                              stan::is_vt_not_complex<T5__>,
                              stan::is_eigen_matrix_dynamic<T6__>,
                              stan::is_vt_not_complex<T6__>,
                              stan::is_eigen_matrix_dynamic<T7__>,
                              stan::is_vt_not_complex<T7__>,
                              stan::is_col_vector<T8__>,
                              stan::is_vt_not_complex<T8__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>,
                stan::base_type_t<T2__>, stan::base_type_t<T3__>, T4__,
                stan::base_type_t<T5__>,
                stan::promote_args_t<stan::base_type_t<T6__>,
                  stan::base_type_t<T7__>, stan::base_type_t<T8__>>>,-1,-1>
gaussian_smoother(const T0__& y_arg__, const std::vector<int>& y_miss,
                  const T2__& a1_arg__, const T3__& P1_arg__, const T4__& Ht,
                  const T5__& Tt_arg__, const T6__& Rt_arg__, const T7__&
                  xreg_arg__, const T8__& gamma2_y_arg__, std::ostream*
                  pstream__);
template <typename T0__, typename T2__, typename T3__, typename T4__,
          typename T5__, typename T6__, typename T7__, typename T8__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>,
                              stan::is_eigen_matrix_dynamic<T3__>,
                              stan::is_vt_not_complex<T3__>,
                              stan::is_stan_scalar<T4__>,
                              stan::is_eigen_matrix_dynamic<T5__>,
                              stan::is_vt_not_complex<T5__>,
                              stan::is_eigen_matrix_dynamic<T6__>,
                              stan::is_vt_not_complex<T6__>,
                              stan::is_eigen_matrix_dynamic<T7__>,
                              stan::is_vt_not_complex<T7__>,
                              stan::is_col_vector<T8__>,
                              stan::is_vt_not_complex<T8__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>,
                stan::base_type_t<T2__>, stan::base_type_t<T3__>, T4__,
                stan::base_type_t<T5__>,
                stan::promote_args_t<stan::base_type_t<T6__>,
                  stan::base_type_t<T7__>, stan::base_type_t<T8__>>>,-1,1>
gaussian_filter(const T0__& y_arg__, const std::vector<int>& y_miss,
                const T2__& a1_arg__, const T3__& P1_arg__, const T4__& Ht,
                const T5__& Tt_arg__, const T6__& Rt_arg__, const T7__&
                xreg_arg__, const T8__& gamma2_y_arg__, std::ostream*
                pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             stan::base_type_t<T2__>,
                             stan::base_type_t<T3__>, T4__,
                             stan::base_type_t<T5__>,
                             stan::promote_args_t<stan::base_type_t<T6__>,
                               stan::base_type_t<T7__>,
                               stan::base_type_t<T8__>>>;
  int current_statement__ = 0;
  const auto& y = stan::math::to_ref(y_arg__);
  const auto& a1 = stan::math::to_ref(a1_arg__);
  const auto& P1 = stan::math::to_ref(P1_arg__);
  const auto& Tt = stan::math::to_ref(Tt_arg__);
  const auto& Rt = stan::math::to_ref(Rt_arg__);
  const auto& xreg = stan::math::to_ref(xreg_arg__);
  const auto& gamma2_y = stan::math::to_ref(gamma2_y_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int k = std::numeric_limits<int>::min();
    current_statement__ = 153;
    k = stan::math::rows(xreg);
    int n = std::numeric_limits<int>::min();
    current_statement__ = 154;
    n = stan::math::rows(y);
    int m = std::numeric_limits<int>::min();
    current_statement__ = 155;
    m = stan::math::rows(a1);
    current_statement__ = 156;
    stan::math::validate_non_negative_index("loglik", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> loglik =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 157;
    stan::model::assign(loglik,
      stan::math::rep_vector(stan::math::negative_infinity(), n),
      "assigning variable loglik");
    current_statement__ = 158;
    stan::math::validate_non_negative_index("x", "m", m);
    Eigen::Matrix<local_scalar_t__,-1,1> x =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(m, DUMMY_VAR__);
    current_statement__ = 159;
    stan::model::assign(x, a1, "assigning variable x");
    current_statement__ = 160;
    stan::math::validate_non_negative_index("P", "m", m);
    current_statement__ = 161;
    stan::math::validate_non_negative_index("P", "m", m);
    Eigen::Matrix<local_scalar_t__,-1,-1> P =
      Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(m, m, DUMMY_VAR__);
    current_statement__ = 162;
    stan::model::assign(P, P1, "assigning variable P");
    local_scalar_t__ log2pi = DUMMY_VAR__;
    current_statement__ = 163;
    log2pi = stan::math::log((2 * stan::math::pi()));
    current_statement__ = 183;
    for (int t = 1; t <= n; ++t) {
      local_scalar_t__ F = DUMMY_VAR__;
      current_statement__ = 164;
      F = (stan::math::quad_form(
             stan::model::rvalue(P, "P", stan::model::index_min_max(1, k),
               stan::model::index_min_max(1, k)),
             stan::model::rvalue(xreg, "xreg", stan::model::index_omni(),
               stan::model::index_uni(t)))
        +
        (stan::model::rvalue(gamma2_y, "gamma2_y", stan::model::index_uni(t))
        * Ht));
      current_statement__ = 181;
      if (stan::math::logical_eq(
            stan::model::rvalue(y_miss, "y_miss", stan::model::index_uni(t)),
            0)) {
        local_scalar_t__ v = DUMMY_VAR__;
        current_statement__ = 171;
        v = (stan::model::rvalue(y, "y", stan::model::index_uni(t)) -
          stan::math::dot_product(
            stan::model::rvalue(xreg, "xreg", stan::model::index_omni(),
              stan::model::index_uni(t)), stan::math::head(x, k)));
        current_statement__ = 172;
        stan::math::validate_non_negative_index("K", "m", m);
        Eigen::Matrix<local_scalar_t__,-1,1> K =
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(m, DUMMY_VAR__);
        current_statement__ = 173;
        stan::model::assign(K,
          stan::math::divide(
            stan::math::multiply(
              stan::model::rvalue(P, "P", stan::model::index_min_max(1, m),
                stan::model::index_min_max(1, k)),
              stan::model::rvalue(xreg, "xreg", stan::model::index_omni(),
                stan::model::index_uni(t))), F), "assigning variable K");
        current_statement__ = 174;
        stan::model::assign(x,
          stan::math::multiply(Tt,
            stan::math::add(stan::model::deep_copy(x),
              stan::math::multiply(K, v))), "assigning variable x");
        current_statement__ = 175;
        stan::model::assign(P,
          stan::math::quad_form_sym(
            stan::math::subtract(stan::model::deep_copy(P),
              stan::math::multiply(
                stan::math::multiply(K, stan::math::transpose(K)), F)),
            stan::math::transpose(Tt)), "assigning variable P");
        current_statement__ = 178;
        for (int i = 1; i <= m; ++i) {
          current_statement__ = 176;
          stan::model::assign(P,
            (stan::model::rvalue(P, "P", stan::model::index_uni(i),
               stan::model::index_uni(i)) +
            stan::model::rvalue(Rt, "Rt", stan::model::index_uni(i),
              stan::model::index_uni(t))), "assigning variable P",
            stan::model::index_uni(i), stan::model::index_uni(i));
        }
        current_statement__ = 179;
        stan::model::assign(loglik, (-0.5 * ((log2pi + stan::math::log(F)) +
          ((v * v) / F))), "assigning variable loglik",
          stan::model::index_uni(t));
      } else {
        current_statement__ = 165;
        stan::model::assign(x,
          stan::math::multiply(Tt, stan::model::deep_copy(x)),
          "assigning variable x");
        current_statement__ = 166;
        stan::model::assign(P,
          stan::math::quad_form_sym(stan::model::deep_copy(P),
            stan::math::transpose(Tt)), "assigning variable P");
        current_statement__ = 169;
        for (int i = 1; i <= m; ++i) {
          current_statement__ = 167;
          stan::model::assign(P,
            (stan::model::rvalue(P, "P", stan::model::index_uni(i),
               stan::model::index_uni(i)) +
            stan::model::rvalue(Rt, "Rt", stan::model::index_uni(i),
              stan::model::index_uni(t))), "assigning variable P",
            stan::model::index_uni(i), stan::model::index_uni(i));
        }
      }
    }
    current_statement__ = 184;
    return loglik;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, typename T2__, typename T3__, typename T4__,
          typename T5__, typename T6__, typename T7__, typename T8__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>,
                              stan::is_eigen_matrix_dynamic<T3__>,
                              stan::is_vt_not_complex<T3__>,
                              stan::is_stan_scalar<T4__>,
                              stan::is_eigen_matrix_dynamic<T5__>,
                              stan::is_vt_not_complex<T5__>,
                              stan::is_eigen_matrix_dynamic<T6__>,
                              stan::is_vt_not_complex<T6__>,
                              stan::is_eigen_matrix_dynamic<T7__>,
                              stan::is_vt_not_complex<T7__>,
                              stan::is_col_vector<T8__>,
                              stan::is_vt_not_complex<T8__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>,
                stan::base_type_t<T2__>, stan::base_type_t<T3__>, T4__,
                stan::base_type_t<T5__>,
                stan::promote_args_t<stan::base_type_t<T6__>,
                  stan::base_type_t<T7__>, stan::base_type_t<T8__>>>,-1,-1>
gaussian_smoother(const T0__& y_arg__, const std::vector<int>& y_miss,
                  const T2__& a1_arg__, const T3__& P1_arg__, const T4__& Ht,
                  const T5__& Tt_arg__, const T6__& Rt_arg__, const T7__&
                  xreg_arg__, const T8__& gamma2_y_arg__, std::ostream*
                  pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             stan::base_type_t<T2__>,
                             stan::base_type_t<T3__>, T4__,
                             stan::base_type_t<T5__>,
                             stan::promote_args_t<stan::base_type_t<T6__>,
                               stan::base_type_t<T7__>,
                               stan::base_type_t<T8__>>>;
  int current_statement__ = 0;
  const auto& y = stan::math::to_ref(y_arg__);
  const auto& a1 = stan::math::to_ref(a1_arg__);
  const auto& P1 = stan::math::to_ref(P1_arg__);
  const auto& Tt = stan::math::to_ref(Tt_arg__);
  const auto& Rt = stan::math::to_ref(Rt_arg__);
  const auto& xreg = stan::math::to_ref(xreg_arg__);
  const auto& gamma2_y = stan::math::to_ref(gamma2_y_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int k = std::numeric_limits<int>::min();
    current_statement__ = 186;
    k = stan::math::rows(xreg);
    int n = std::numeric_limits<int>::min();
    current_statement__ = 187;
    n = stan::math::rows(y);
    int m = std::numeric_limits<int>::min();
    current_statement__ = 188;
    m = stan::math::rows(a1);
    current_statement__ = 189;
    stan::math::validate_non_negative_index("x", "m", m);
    Eigen::Matrix<local_scalar_t__,-1,1> x =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(m, DUMMY_VAR__);
    current_statement__ = 190;
    stan::model::assign(x, a1, "assigning variable x");
    current_statement__ = 191;
    stan::math::validate_non_negative_index("P", "m", m);
    current_statement__ = 192;
    stan::math::validate_non_negative_index("P", "m", m);
    Eigen::Matrix<local_scalar_t__,-1,-1> P =
      Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(m, m, DUMMY_VAR__);
    current_statement__ = 193;
    stan::model::assign(P, P1, "assigning variable P");
    current_statement__ = 194;
    stan::math::validate_non_negative_index("v", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> v =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 196;
    stan::math::validate_non_negative_index("F", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> F =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 198;
    stan::math::validate_non_negative_index("K", "m", m);
    current_statement__ = 199;
    stan::math::validate_non_negative_index("K", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,-1> K =
      Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(m, n, DUMMY_VAR__);
    current_statement__ = 201;
    stan::math::validate_non_negative_index("r", "m", m);
    current_statement__ = 202;
    stan::math::validate_non_negative_index("r", "n + 1", (n + 1));
    Eigen::Matrix<local_scalar_t__,-1,-1> r =
      Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(m, (n + 1),
        DUMMY_VAR__);
    current_statement__ = 204;
    stan::math::validate_non_negative_index("tmpr", "m", m);
    Eigen::Matrix<local_scalar_t__,-1,1> tmpr =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(m, DUMMY_VAR__);
    current_statement__ = 223;
    for (int t = 1; t <= n; ++t) {
      current_statement__ = 206;
      stan::model::assign(F,
        (stan::math::quad_form(
           stan::model::rvalue(P, "P", stan::model::index_min_max(1, k),
             stan::model::index_min_max(1, k)),
           stan::model::rvalue(xreg, "xreg", stan::model::index_omni(),
             stan::model::index_uni(t))) +
        (stan::model::rvalue(gamma2_y, "gamma2_y", stan::model::index_uni(t))
        * Ht)), "assigning variable F", stan::model::index_uni(t));
      current_statement__ = 221;
      if ((stan::math::primitive_value(
             stan::math::logical_eq(
               stan::model::rvalue(y_miss, "y_miss",
                 stan::model::index_uni(t)), 0))
          &&
          stan::math::primitive_value(
            stan::math::logical_gt(
              stan::model::rvalue(F, "F", stan::model::index_uni(t)), 1.0e-12)))) {
        current_statement__ = 213;
        stan::model::assign(v,
          (stan::model::rvalue(y, "y", stan::model::index_uni(t)) -
          stan::math::dot_product(
            stan::model::rvalue(xreg, "xreg", stan::model::index_omni(),
              stan::model::index_uni(t)), stan::math::head(x, k))),
          "assigning variable v", stan::model::index_uni(t));
        current_statement__ = 214;
        stan::model::assign(K,
          stan::math::divide(
            stan::math::multiply(
              stan::model::rvalue(P, "P", stan::model::index_min_max(1, m),
                stan::model::index_min_max(1, k)),
              stan::model::rvalue(xreg, "xreg", stan::model::index_omni(),
                stan::model::index_uni(t))),
            stan::model::rvalue(F, "F", stan::model::index_uni(t))),
          "assigning variable K", stan::model::index_omni(),
          stan::model::index_uni(t));
        current_statement__ = 215;
        stan::model::assign(x,
          stan::math::multiply(Tt,
            stan::math::add(stan::model::deep_copy(x),
              stan::math::multiply(
                stan::model::rvalue(K, "K", stan::model::index_omni(),
                  stan::model::index_uni(t)),
                stan::model::rvalue(v, "v", stan::model::index_uni(t))))),
          "assigning variable x");
        current_statement__ = 216;
        stan::model::assign(P,
          stan::math::quad_form_sym(
            stan::math::subtract(stan::model::deep_copy(P),
              stan::math::multiply(
                stan::math::multiply(
                  stan::model::rvalue(K, "K", stan::model::index_omni(),
                    stan::model::index_uni(t)),
                  stan::math::transpose(
                    stan::model::rvalue(K, "K", stan::model::index_omni(),
                      stan::model::index_uni(t)))),
                stan::model::rvalue(F, "F", stan::model::index_uni(t)))),
            stan::math::transpose(Tt)), "assigning variable P");
        current_statement__ = 219;
        for (int i = 1; i <= m; ++i) {
          current_statement__ = 217;
          stan::model::assign(P,
            (stan::model::rvalue(P, "P", stan::model::index_uni(i),
               stan::model::index_uni(i)) +
            stan::model::rvalue(Rt, "Rt", stan::model::index_uni(i),
              stan::model::index_uni(t))), "assigning variable P",
            stan::model::index_uni(i), stan::model::index_uni(i));
        }
      } else {
        current_statement__ = 207;
        stan::model::assign(x,
          stan::math::multiply(Tt, stan::model::deep_copy(x)),
          "assigning variable x");
        current_statement__ = 208;
        stan::model::assign(P,
          stan::math::quad_form_sym(stan::model::deep_copy(P),
            stan::math::transpose(Tt)), "assigning variable P");
        current_statement__ = 211;
        for (int i = 1; i <= m; ++i) {
          current_statement__ = 209;
          stan::model::assign(P,
            (stan::model::rvalue(P, "P", stan::model::index_uni(i),
               stan::model::index_uni(i)) +
            stan::model::rvalue(Rt, "Rt", stan::model::index_uni(i),
              stan::model::index_uni(t))), "assigning variable P",
            stan::model::index_uni(i), stan::model::index_uni(i));
        }
      }
    }
    current_statement__ = 224;
    stan::model::assign(r, stan::math::rep_vector(0.0, m),
      "assigning variable r", stan::model::index_omni(),
      stan::model::index_uni((n + 1)));
    current_statement__ = 237;
    for (int tt = 1; tt <= n; ++tt) {
      int t = std::numeric_limits<int>::min();
      current_statement__ = 225;
      t = ((n + 1) - tt);
      current_statement__ = 226;
      stan::math::validate_non_negative_index("tmp", "m", m);
      Eigen::Matrix<local_scalar_t__,-1,1> tmp =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(m, DUMMY_VAR__);
      current_statement__ = 227;
      stan::model::assign(tmp,
        stan::model::rvalue(r, "r", stan::model::index_omni(),
          stan::model::index_uni((t + 1))), "assigning variable tmp");
      current_statement__ = 235;
      if ((stan::math::primitive_value(
             stan::math::logical_eq(
               stan::model::rvalue(y_miss, "y_miss",
                 stan::model::index_uni(t)), 0))
          &&
          stan::math::primitive_value(
            stan::math::logical_gt(
              stan::model::rvalue(F, "F", stan::model::index_uni(t)), 1.0e-12)))) {
        current_statement__ = 230;
        stan::math::validate_non_negative_index("tmp2", "m", m);
        Eigen::Matrix<local_scalar_t__,-1,1> tmp2 =
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(m, DUMMY_VAR__);
        current_statement__ = 231;
        stan::model::assign(tmp2, stan::math::rep_vector(0.0, m),
          "assigning variable tmp2");
        current_statement__ = 232;
        stan::model::assign(tmp2,
          stan::model::rvalue(xreg, "xreg", stan::model::index_omni(),
            stan::model::index_uni(t)), "assigning variable tmp2",
          stan::model::index_min_max(1, k));
        current_statement__ = 233;
        stan::model::assign(r,
          stan::math::add(
            stan::math::divide(
              stan::math::multiply(tmp2,
                stan::model::rvalue(v, "v", stan::model::index_uni(t))),
              stan::model::rvalue(F, "F", stan::model::index_uni(t))),
            stan::math::multiply(
              stan::math::transpose(
                stan::math::subtract(Tt,
                  stan::math::multiply(
                    stan::math::multiply(Tt,
                      stan::model::rvalue(K, "K", stan::model::index_omni(),
                        stan::model::index_uni(t))),
                    stan::math::transpose(tmp2)))), tmp)),
          "assigning variable r", stan::model::index_omni(),
          stan::model::index_uni(t));
      } else {
        current_statement__ = 228;
        stan::model::assign(r,
          stan::math::multiply(stan::math::transpose(Tt), tmp),
          "assigning variable r", stan::model::index_omni(),
          stan::model::index_uni(t));
      }
    }
    current_statement__ = 238;
    stan::model::assign(tmpr,
      stan::model::rvalue(r, "r", stan::model::index_omni(),
        stan::model::index_uni(1)), "assigning variable tmpr");
    current_statement__ = 239;
    stan::model::assign(r,
      stan::math::add(a1, stan::math::multiply(P1, tmpr)),
      "assigning variable r", stan::model::index_omni(),
      stan::model::index_uni(1));
    current_statement__ = 246;
    for (int t = 2; t <= n; ++t) {
      current_statement__ = 240;
      stan::math::validate_non_negative_index("tmp", "m", m);
      Eigen::Matrix<local_scalar_t__,-1,1> tmp =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(m, DUMMY_VAR__);
      current_statement__ = 241;
      stan::model::assign(tmp,
        stan::model::rvalue(r, "r", stan::model::index_omni(),
          stan::model::index_uni((t - 1))), "assigning variable tmp");
      current_statement__ = 242;
      stan::math::validate_non_negative_index("tmp2", "m", m);
      Eigen::Matrix<local_scalar_t__,-1,1> tmp2 =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(m, DUMMY_VAR__);
      current_statement__ = 243;
      stan::model::assign(tmp2,
        stan::model::rvalue(r, "r", stan::model::index_omni(),
          stan::model::index_uni(t)), "assigning variable tmp2");
      current_statement__ = 244;
      stan::model::assign(r,
        stan::math::add(stan::math::multiply(Tt, tmp),
          stan::math::elt_multiply(
            stan::model::rvalue(Rt, "Rt", stan::model::index_omni(),
              stan::model::index_uni(t)), tmp2)), "assigning variable r",
        stan::model::index_omni(), stan::model::index_uni(t));
    }
    current_statement__ = 247;
    return stan::model::rvalue(r, "r", stan::model::index_min_max(1, m),
             stan::model::index_min_max(1, n));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_walker_lm final : public model_base_crtp<model_walker_lm> {
private:
  int k_fixed;
  int k_rw1;
  int k_rw2;
  int m;
  int k;
  int n;
  int n_lfo;
  Eigen::Matrix<double,-1,-1> xreg_fixed_data__;
  Eigen::Matrix<double,-1,-1> xreg_rw_data__;
  Eigen::Matrix<double,-1,1> y_data__;
  std::vector<int> y_miss;
  double sigma_y_shape;
  double sigma_y_rate;
  double beta_fixed_mean;
  double beta_fixed_sd;
  double beta_rw1_mean;
  double beta_rw1_sd;
  double beta_rw2_mean;
  double beta_rw2_sd;
  double sigma_rw1_shape;
  double sigma_rw2_shape;
  double sigma_rw1_rate;
  double sigma_rw2_rate;
  double nu_mean;
  double nu_sd;
  Eigen::Matrix<double,-1,1> gamma_y_data__;
  Eigen::Matrix<double,-1,-1> gamma_rw1_data__;
  Eigen::Matrix<double,-1,-1> gamma_rw2_data__;
  std::vector<int> obs_idx;
  Eigen::Matrix<double,-1,1> a1_data__;
  Eigen::Matrix<double,-1,-1> P1_data__;
  Eigen::Matrix<double,-1,-1> Tt_data__;
  Eigen::Matrix<double,-1,1> gamma2_y_data__;
  int y_rep_1dim__;
  int beta_rw_2dim__;
  int nu_2dim__;
  int y_fit_1dim__;
  Eigen::Map<Eigen::Matrix<double,-1,-1>> xreg_fixed{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> xreg_rw{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> y{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> gamma_y{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> gamma_rw1{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> gamma_rw2{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> a1{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> P1{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> Tt{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> gamma2_y{nullptr, 0};
public:
  ~model_walker_lm() {}
  model_walker_lm(stan::io::var_context& context__, unsigned int
                  random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_walker_lm_namespace::model_walker_lm";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 65;
      context__.validate_dims("data initialization", "k_fixed", "int",
        std::vector<size_t>{});
      k_fixed = std::numeric_limits<int>::min();
      current_statement__ = 65;
      k_fixed = context__.vals_i("k_fixed")[(1 - 1)];
      current_statement__ = 65;
      stan::math::check_greater_or_equal(function__, "k_fixed", k_fixed, 0);
      current_statement__ = 66;
      context__.validate_dims("data initialization", "k_rw1", "int",
        std::vector<size_t>{});
      k_rw1 = std::numeric_limits<int>::min();
      current_statement__ = 66;
      k_rw1 = context__.vals_i("k_rw1")[(1 - 1)];
      current_statement__ = 66;
      stan::math::check_greater_or_equal(function__, "k_rw1", k_rw1, 0);
      current_statement__ = 67;
      context__.validate_dims("data initialization", "k_rw2", "int",
        std::vector<size_t>{});
      k_rw2 = std::numeric_limits<int>::min();
      current_statement__ = 67;
      k_rw2 = context__.vals_i("k_rw2")[(1 - 1)];
      current_statement__ = 67;
      stan::math::check_greater_or_equal(function__, "k_rw2", k_rw2, 0);
      current_statement__ = 68;
      context__.validate_dims("data initialization", "m", "int",
        std::vector<size_t>{});
      m = std::numeric_limits<int>::min();
      current_statement__ = 68;
      m = context__.vals_i("m")[(1 - 1)];
      current_statement__ = 68;
      stan::math::check_greater_or_equal(function__, "m", m, 0);
      current_statement__ = 69;
      context__.validate_dims("data initialization", "k", "int",
        std::vector<size_t>{});
      k = std::numeric_limits<int>::min();
      current_statement__ = 69;
      k = context__.vals_i("k")[(1 - 1)];
      current_statement__ = 69;
      stan::math::check_greater_or_equal(function__, "k", k, 0);
      current_statement__ = 70;
      context__.validate_dims("data initialization", "n", "int",
        std::vector<size_t>{});
      n = std::numeric_limits<int>::min();
      current_statement__ = 70;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 70;
      stan::math::check_greater_or_equal(function__, "n", n, 1);
      current_statement__ = 71;
      context__.validate_dims("data initialization", "n_lfo", "int",
        std::vector<size_t>{});
      n_lfo = std::numeric_limits<int>::min();
      current_statement__ = 71;
      n_lfo = context__.vals_i("n_lfo")[(1 - 1)];
      current_statement__ = 71;
      stan::math::check_greater_or_equal(function__, "n_lfo", n_lfo, 1);
      current_statement__ = 72;
      stan::math::validate_non_negative_index("xreg_fixed", "n", n);
      current_statement__ = 73;
      stan::math::validate_non_negative_index("xreg_fixed", "k_fixed",
        k_fixed);
      current_statement__ = 74;
      context__.validate_dims("data initialization", "xreg_fixed", "double",
        std::vector<size_t>{static_cast<size_t>(n),
          static_cast<size_t>(k_fixed)});
      xreg_fixed_data__ = Eigen::Matrix<double,-1,-1>::Constant(n, k_fixed,
                            std::numeric_limits<double>::quiet_NaN());
      new (&xreg_fixed)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(xreg_fixed_data__.data(), n,
        k_fixed);
      {
        std::vector<local_scalar_t__> xreg_fixed_flat__;
        current_statement__ = 74;
        xreg_fixed_flat__ = context__.vals_r("xreg_fixed");
        current_statement__ = 74;
        pos__ = 1;
        current_statement__ = 74;
        for (int sym1__ = 1; sym1__ <= k_fixed; ++sym1__) {
          current_statement__ = 74;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 74;
            stan::model::assign(xreg_fixed, xreg_fixed_flat__[(pos__ - 1)],
              "assigning variable xreg_fixed",
              stan::model::index_uni(sym2__), stan::model::index_uni(sym1__));
            current_statement__ = 74;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 75;
      stan::math::validate_non_negative_index("xreg_rw", "k", k);
      current_statement__ = 76;
      stan::math::validate_non_negative_index("xreg_rw", "n", n);
      current_statement__ = 77;
      context__.validate_dims("data initialization", "xreg_rw", "double",
        std::vector<size_t>{static_cast<size_t>(k), static_cast<size_t>(n)});
      xreg_rw_data__ = Eigen::Matrix<double,-1,-1>::Constant(k, n,
                         std::numeric_limits<double>::quiet_NaN());
      new (&xreg_rw)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(xreg_rw_data__.data(), k, n);
      {
        std::vector<local_scalar_t__> xreg_rw_flat__;
        current_statement__ = 77;
        xreg_rw_flat__ = context__.vals_r("xreg_rw");
        current_statement__ = 77;
        pos__ = 1;
        current_statement__ = 77;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 77;
          for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
            current_statement__ = 77;
            stan::model::assign(xreg_rw, xreg_rw_flat__[(pos__ - 1)],
              "assigning variable xreg_rw", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 77;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 78;
      stan::math::validate_non_negative_index("y", "n", n);
      current_statement__ = 79;
      context__.validate_dims("data initialization", "y", "double",
        std::vector<size_t>{static_cast<size_t>(n)});
      y_data__ = Eigen::Matrix<double,-1,1>::Constant(n,
                   std::numeric_limits<double>::quiet_NaN());
      new (&y) Eigen::Map<Eigen::Matrix<double,-1,1>>(y_data__.data(), n);
      {
        std::vector<local_scalar_t__> y_flat__;
        current_statement__ = 79;
        y_flat__ = context__.vals_r("y");
        current_statement__ = 79;
        pos__ = 1;
        current_statement__ = 79;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 79;
          stan::model::assign(y, y_flat__[(pos__ - 1)],
            "assigning variable y", stan::model::index_uni(sym1__));
          current_statement__ = 79;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 80;
      stan::math::validate_non_negative_index("y_miss", "n", n);
      current_statement__ = 81;
      context__.validate_dims("data initialization", "y_miss", "int",
        std::vector<size_t>{static_cast<size_t>(n)});
      y_miss = std::vector<int>(n, std::numeric_limits<int>::min());
      current_statement__ = 81;
      y_miss = context__.vals_i("y_miss");
      current_statement__ = 81;
      stan::math::check_greater_or_equal(function__, "y_miss", y_miss, 0);
      current_statement__ = 82;
      context__.validate_dims("data initialization", "sigma_y_shape",
        "double", std::vector<size_t>{});
      sigma_y_shape = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 82;
      sigma_y_shape = context__.vals_r("sigma_y_shape")[(1 - 1)];
      current_statement__ = 82;
      stan::math::check_greater_or_equal(function__, "sigma_y_shape",
        sigma_y_shape, 0);
      current_statement__ = 83;
      context__.validate_dims("data initialization", "sigma_y_rate",
        "double", std::vector<size_t>{});
      sigma_y_rate = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 83;
      sigma_y_rate = context__.vals_r("sigma_y_rate")[(1 - 1)];
      current_statement__ = 83;
      stan::math::check_greater_or_equal(function__, "sigma_y_rate",
        sigma_y_rate, 0);
      current_statement__ = 84;
      context__.validate_dims("data initialization", "beta_fixed_mean",
        "double", std::vector<size_t>{});
      beta_fixed_mean = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 84;
      beta_fixed_mean = context__.vals_r("beta_fixed_mean")[(1 - 1)];
      current_statement__ = 85;
      context__.validate_dims("data initialization", "beta_fixed_sd",
        "double", std::vector<size_t>{});
      beta_fixed_sd = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 85;
      beta_fixed_sd = context__.vals_r("beta_fixed_sd")[(1 - 1)];
      current_statement__ = 85;
      stan::math::check_greater_or_equal(function__, "beta_fixed_sd",
        beta_fixed_sd, 0);
      current_statement__ = 86;
      context__.validate_dims("data initialization", "beta_rw1_mean",
        "double", std::vector<size_t>{});
      beta_rw1_mean = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 86;
      beta_rw1_mean = context__.vals_r("beta_rw1_mean")[(1 - 1)];
      current_statement__ = 87;
      context__.validate_dims("data initialization", "beta_rw1_sd", "double",
        std::vector<size_t>{});
      beta_rw1_sd = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 87;
      beta_rw1_sd = context__.vals_r("beta_rw1_sd")[(1 - 1)];
      current_statement__ = 87;
      stan::math::check_greater_or_equal(function__, "beta_rw1_sd",
        beta_rw1_sd, 0);
      current_statement__ = 88;
      context__.validate_dims("data initialization", "beta_rw2_mean",
        "double", std::vector<size_t>{});
      beta_rw2_mean = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 88;
      beta_rw2_mean = context__.vals_r("beta_rw2_mean")[(1 - 1)];
      current_statement__ = 89;
      context__.validate_dims("data initialization", "beta_rw2_sd", "double",
        std::vector<size_t>{});
      beta_rw2_sd = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 89;
      beta_rw2_sd = context__.vals_r("beta_rw2_sd")[(1 - 1)];
      current_statement__ = 89;
      stan::math::check_greater_or_equal(function__, "beta_rw2_sd",
        beta_rw2_sd, 0);
      current_statement__ = 90;
      context__.validate_dims("data initialization", "sigma_rw1_shape",
        "double", std::vector<size_t>{});
      sigma_rw1_shape = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 90;
      sigma_rw1_shape = context__.vals_r("sigma_rw1_shape")[(1 - 1)];
      current_statement__ = 90;
      stan::math::check_greater_or_equal(function__, "sigma_rw1_shape",
        sigma_rw1_shape, 0);
      current_statement__ = 91;
      context__.validate_dims("data initialization", "sigma_rw2_shape",
        "double", std::vector<size_t>{});
      sigma_rw2_shape = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 91;
      sigma_rw2_shape = context__.vals_r("sigma_rw2_shape")[(1 - 1)];
      current_statement__ = 91;
      stan::math::check_greater_or_equal(function__, "sigma_rw2_shape",
        sigma_rw2_shape, 0);
      current_statement__ = 92;
      context__.validate_dims("data initialization", "sigma_rw1_rate",
        "double", std::vector<size_t>{});
      sigma_rw1_rate = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 92;
      sigma_rw1_rate = context__.vals_r("sigma_rw1_rate")[(1 - 1)];
      current_statement__ = 92;
      stan::math::check_greater_or_equal(function__, "sigma_rw1_rate",
        sigma_rw1_rate, 0);
      current_statement__ = 93;
      context__.validate_dims("data initialization", "sigma_rw2_rate",
        "double", std::vector<size_t>{});
      sigma_rw2_rate = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 93;
      sigma_rw2_rate = context__.vals_r("sigma_rw2_rate")[(1 - 1)];
      current_statement__ = 93;
      stan::math::check_greater_or_equal(function__, "sigma_rw2_rate",
        sigma_rw2_rate, 0);
      current_statement__ = 94;
      context__.validate_dims("data initialization", "nu_mean", "double",
        std::vector<size_t>{});
      nu_mean = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 94;
      nu_mean = context__.vals_r("nu_mean")[(1 - 1)];
      current_statement__ = 94;
      stan::math::check_greater_or_equal(function__, "nu_mean", nu_mean, 0);
      current_statement__ = 95;
      context__.validate_dims("data initialization", "nu_sd", "double",
        std::vector<size_t>{});
      nu_sd = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 95;
      nu_sd = context__.vals_r("nu_sd")[(1 - 1)];
      current_statement__ = 95;
      stan::math::check_greater_or_equal(function__, "nu_sd", nu_sd, 0);
      current_statement__ = 96;
      stan::math::validate_non_negative_index("gamma_y", "n", n);
      current_statement__ = 97;
      context__.validate_dims("data initialization", "gamma_y", "double",
        std::vector<size_t>{static_cast<size_t>(n)});
      gamma_y_data__ = Eigen::Matrix<double,-1,1>::Constant(n,
                         std::numeric_limits<double>::quiet_NaN());
      new (&gamma_y)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(gamma_y_data__.data(), n);
      {
        std::vector<local_scalar_t__> gamma_y_flat__;
        current_statement__ = 97;
        gamma_y_flat__ = context__.vals_r("gamma_y");
        current_statement__ = 97;
        pos__ = 1;
        current_statement__ = 97;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 97;
          stan::model::assign(gamma_y, gamma_y_flat__[(pos__ - 1)],
            "assigning variable gamma_y", stan::model::index_uni(sym1__));
          current_statement__ = 97;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 98;
      stan::math::validate_non_negative_index("gamma_rw1", "k_rw1", k_rw1);
      current_statement__ = 99;
      stan::math::validate_non_negative_index("gamma_rw1", "n", n);
      current_statement__ = 100;
      context__.validate_dims("data initialization", "gamma_rw1", "double",
        std::vector<size_t>{static_cast<size_t>(k_rw1),
          static_cast<size_t>(n)});
      gamma_rw1_data__ = Eigen::Matrix<double,-1,-1>::Constant(k_rw1, n,
                           std::numeric_limits<double>::quiet_NaN());
      new (&gamma_rw1)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(gamma_rw1_data__.data(),
        k_rw1, n);
      {
        std::vector<local_scalar_t__> gamma_rw1_flat__;
        current_statement__ = 100;
        gamma_rw1_flat__ = context__.vals_r("gamma_rw1");
        current_statement__ = 100;
        pos__ = 1;
        current_statement__ = 100;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 100;
          for (int sym2__ = 1; sym2__ <= k_rw1; ++sym2__) {
            current_statement__ = 100;
            stan::model::assign(gamma_rw1, gamma_rw1_flat__[(pos__ - 1)],
              "assigning variable gamma_rw1", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 100;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 101;
      stan::math::validate_non_negative_index("gamma_rw2", "k_rw2", k_rw2);
      current_statement__ = 102;
      stan::math::validate_non_negative_index("gamma_rw2", "n", n);
      current_statement__ = 103;
      context__.validate_dims("data initialization", "gamma_rw2", "double",
        std::vector<size_t>{static_cast<size_t>(k_rw2),
          static_cast<size_t>(n)});
      gamma_rw2_data__ = Eigen::Matrix<double,-1,-1>::Constant(k_rw2, n,
                           std::numeric_limits<double>::quiet_NaN());
      new (&gamma_rw2)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(gamma_rw2_data__.data(),
        k_rw2, n);
      {
        std::vector<local_scalar_t__> gamma_rw2_flat__;
        current_statement__ = 103;
        gamma_rw2_flat__ = context__.vals_r("gamma_rw2");
        current_statement__ = 103;
        pos__ = 1;
        current_statement__ = 103;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 103;
          for (int sym2__ = 1; sym2__ <= k_rw2; ++sym2__) {
            current_statement__ = 103;
            stan::model::assign(gamma_rw2, gamma_rw2_flat__[(pos__ - 1)],
              "assigning variable gamma_rw2", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 103;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 104;
      stan::math::validate_non_negative_index("obs_idx",
        "n_lfo - sum(y_miss[1 : n_lfo])", (n_lfo -
        stan::math::sum(
          stan::model::rvalue(y_miss, "y_miss",
            stan::model::index_min_max(1, n_lfo)))));
      current_statement__ = 105;
      obs_idx = std::vector<int>((n_lfo -
                  stan::math::sum(
                    stan::model::rvalue(y_miss, "y_miss",
                      stan::model::index_min_max(1, n_lfo)))),
                  std::numeric_limits<int>::min());
      current_statement__ = 106;
      stan::math::validate_non_negative_index("a1", "m", m);
      current_statement__ = 107;
      a1_data__ = Eigen::Matrix<double,-1,1>::Constant(m,
                    std::numeric_limits<double>::quiet_NaN());
      new (&a1) Eigen::Map<Eigen::Matrix<double,-1,1>>(a1_data__.data(), m);
      current_statement__ = 108;
      stan::math::validate_non_negative_index("P1", "m", m);
      current_statement__ = 109;
      stan::math::validate_non_negative_index("P1", "m", m);
      current_statement__ = 110;
      P1_data__ = Eigen::Matrix<double,-1,-1>::Constant(m, m,
                    std::numeric_limits<double>::quiet_NaN());
      new (&P1) Eigen::Map<Eigen::Matrix<double,-1,-1>>(P1_data__.data(), m,
        m);
      current_statement__ = 110;
      stan::model::assign(P1, stan::math::rep_matrix(0.0, m, m),
        "assigning variable P1");
      current_statement__ = 111;
      stan::math::validate_non_negative_index("Tt", "m", m);
      current_statement__ = 112;
      stan::math::validate_non_negative_index("Tt", "m", m);
      current_statement__ = 113;
      Tt_data__ = Eigen::Matrix<double,-1,-1>::Constant(m, m,
                    std::numeric_limits<double>::quiet_NaN());
      new (&Tt) Eigen::Map<Eigen::Matrix<double,-1,-1>>(Tt_data__.data(), m,
        m);
      current_statement__ = 113;
      stan::model::assign(Tt,
        stan::math::diag_matrix(stan::math::rep_vector(1.0, m)),
        "assigning variable Tt");
      current_statement__ = 114;
      stan::math::validate_non_negative_index("gamma2_y", "n", n);
      current_statement__ = 115;
      gamma2_y_data__ = Eigen::Matrix<double,-1,1>::Constant(n,
                          std::numeric_limits<double>::quiet_NaN());
      new (&gamma2_y)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(gamma2_y_data__.data(), n);
      current_statement__ = 115;
      stan::model::assign(gamma2_y,
        stan::math::elt_multiply(gamma_y, gamma_y),
        "assigning variable gamma2_y");
      {
        int ii = std::numeric_limits<int>::min();
        current_statement__ = 116;
        ii = 0;
        current_statement__ = 122;
        for (int i = 1; i <= n_lfo; ++i) {
          current_statement__ = 120;
          if (stan::math::logical_eq(
                stan::model::rvalue(y_miss, "y_miss",
                  stan::model::index_uni(i)), 0)) {
            current_statement__ = 117;
            ii = (ii + 1);
            current_statement__ = 118;
            stan::model::assign(obs_idx, i, "assigning variable obs_idx",
              stan::model::index_uni(ii));
          }
        }
      }
      current_statement__ = 126;
      if (stan::math::logical_gt(k_rw2, 0)) {
        current_statement__ = 124;
        stan::model::assign(Tt,
          stan::math::diag_matrix(stan::math::rep_vector(1.0, k_rw2)),
          "assigning variable Tt",
          stan::model::index_min_max((k_rw1 + 1), k),
          stan::model::index_min_max((k + 1), m));
      }
      current_statement__ = 130;
      for (int i = 1; i <= k_rw1; ++i) {
        current_statement__ = 127;
        stan::model::assign(a1, beta_rw1_mean, "assigning variable a1",
          stan::model::index_uni(i));
        current_statement__ = 128;
        stan::model::assign(P1, stan::math::pow(beta_rw1_sd, 2),
          "assigning variable P1", stan::model::index_uni(i),
          stan::model::index_uni(i));
      }
      current_statement__ = 134;
      for (int i = (k_rw1 + 1); i <= k; ++i) {
        current_statement__ = 131;
        stan::model::assign(a1, beta_rw2_mean, "assigning variable a1",
          stan::model::index_uni(i));
        current_statement__ = 132;
        stan::model::assign(P1, stan::math::pow(beta_rw2_sd, 2),
          "assigning variable P1", stan::model::index_uni(i),
          stan::model::index_uni(i));
      }
      current_statement__ = 138;
      for (int i = (k + 1); i <= m; ++i) {
        current_statement__ = 135;
        stan::model::assign(a1, nu_mean, "assigning variable a1",
          stan::model::index_uni(i));
        current_statement__ = 136;
        stan::model::assign(P1, stan::math::pow(nu_sd, 2),
          "assigning variable P1", stan::model::index_uni(i),
          stan::model::index_uni(i));
      }
      current_statement__ = 139;
      stan::math::validate_non_negative_index("beta_fixed", "k_fixed",
        k_fixed);
      current_statement__ = 140;
      stan::math::validate_non_negative_index("sigma_rw1", "k_rw1", k_rw1);
      current_statement__ = 141;
      stan::math::validate_non_negative_index("sigma_rw2", "k_rw2", k_rw2);
      current_statement__ = 142;
      stan::math::validate_non_negative_index("log_lik", "n", n);
      current_statement__ = 143;
      stan::math::validate_non_negative_index("Rt", "m", m);
      current_statement__ = 144;
      stan::math::validate_non_negative_index("Rt", "n", n);
      current_statement__ = 145;
      stan::math::validate_non_negative_index("xbeta", "n", n);
      current_statement__ = 146;
      stan::math::validate_non_negative_index("y_", "n", n);
      current_statement__ = 147;
      y_rep_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 147;
      y_rep_1dim__ = (n * stan::math::logical_eq(n_lfo, n));
      current_statement__ = 147;
      stan::math::validate_non_negative_index("y_rep", "n * (n_lfo == n)",
        y_rep_1dim__);
      current_statement__ = 148;
      stan::math::validate_non_negative_index("beta_rw", "k", k);
      current_statement__ = 149;
      beta_rw_2dim__ = std::numeric_limits<int>::min();
      current_statement__ = 149;
      beta_rw_2dim__ = (n * stan::math::logical_eq(n_lfo, n));
      current_statement__ = 149;
      stan::math::validate_non_negative_index("beta_rw", "n * (n_lfo == n)",
        beta_rw_2dim__);
      current_statement__ = 150;
      stan::math::validate_non_negative_index("nu", "k_rw2", k_rw2);
      current_statement__ = 151;
      nu_2dim__ = std::numeric_limits<int>::min();
      current_statement__ = 151;
      nu_2dim__ = (n * stan::math::logical_eq(n_lfo, n));
      current_statement__ = 151;
      stan::math::validate_non_negative_index("nu", "n * (n_lfo == n)",
        nu_2dim__);
      current_statement__ = 152;
      y_fit_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 152;
      y_fit_1dim__ = (n * stan::math::logical_eq(n_lfo, n));
      current_statement__ = 152;
      stan::math::validate_non_negative_index("y_fit", "n * (n_lfo == n)",
        y_fit_1dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = k_fixed + k_rw1 + k_rw2 + 1;
  }
  inline std::string model_name() const final {
    return "model_walker_lm";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_walker_lm_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> beta_fixed =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(k_fixed, DUMMY_VAR__);
      current_statement__ = 1;
      beta_fixed = in__.template read<
                     Eigen::Matrix<local_scalar_t__,-1,1>>(k_fixed);
      std::vector<local_scalar_t__> sigma_rw1 =
        std::vector<local_scalar_t__>(k_rw1, DUMMY_VAR__);
      current_statement__ = 2;
      sigma_rw1 = in__.template read_constrain_lb<
                    std::vector<local_scalar_t__>, jacobian__>(0, lp__,
                    k_rw1);
      std::vector<local_scalar_t__> sigma_rw2 =
        std::vector<local_scalar_t__>(k_rw2, DUMMY_VAR__);
      current_statement__ = 3;
      sigma_rw2 = in__.template read_constrain_lb<
                    std::vector<local_scalar_t__>, jacobian__>(0, lp__,
                    k_rw2);
      local_scalar_t__ sigma_y = DUMMY_VAR__;
      current_statement__ = 4;
      sigma_y = in__.template read_constrain_lb<local_scalar_t__,
                  jacobian__>(0, lp__);
      Eigen::Matrix<local_scalar_t__,-1,1> log_lik =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,-1> Rt =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(m, n, DUMMY_VAR__);
      current_statement__ = 6;
      stan::model::assign(Rt, stan::math::rep_matrix(0.0, m, n),
        "assigning variable Rt");
      Eigen::Matrix<local_scalar_t__,-1,1> xbeta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> y_ =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
      current_statement__ = 17;
      if (stan::math::logical_gt(k_fixed, 0)) {
        current_statement__ = 15;
        stan::model::assign(xbeta,
          stan::math::multiply(xreg_fixed, beta_fixed),
          "assigning variable xbeta");
      } else {
        current_statement__ = 13;
        stan::model::assign(xbeta, stan::math::rep_vector(0.0, n),
          "assigning variable xbeta");
      }
      current_statement__ = 18;
      stan::model::assign(y_, stan::math::subtract(y, xbeta),
        "assigning variable y_");
      current_statement__ = 26;
      for (int t = 1; t <= n; ++t) {
        current_statement__ = 21;
        for (int i = 1; i <= k_rw1; ++i) {
          current_statement__ = 19;
          stan::model::assign(Rt,
            stan::math::pow(
              (stan::model::rvalue(gamma_rw1, "gamma_rw1",
                 stan::model::index_uni(i), stan::model::index_uni(t)) *
              stan::model::rvalue(sigma_rw1, "sigma_rw1",
                stan::model::index_uni(i))), 2), "assigning variable Rt",
            stan::model::index_uni(i), stan::model::index_uni(t));
        }
        current_statement__ = 24;
        for (int i = 1; i <= k_rw2; ++i) {
          current_statement__ = 22;
          stan::model::assign(Rt,
            stan::math::pow(
              (stan::model::rvalue(gamma_rw2, "gamma_rw2",
                 stan::model::index_uni(i), stan::model::index_uni(t)) *
              stan::model::rvalue(sigma_rw2, "sigma_rw2",
                stan::model::index_uni(i))), 2), "assigning variable Rt",
            stan::model::index_uni((k + i)), stan::model::index_uni(t));
        }
      }
      current_statement__ = 27;
      stan::model::assign(log_lik,
        gaussian_filter(y_, y_miss, a1, P1, stan::math::pow(sigma_y, 2), Tt,
          Rt, xreg_rw, gamma2_y, pstream__), "assigning variable log_lik");
      {
        current_statement__ = 60;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(beta_fixed,
                         beta_fixed_mean, beta_fixed_sd));
        current_statement__ = 61;
        lp_accum__.add(stan::math::gamma_lpdf<propto__>(sigma_y,
                         sigma_y_shape, sigma_y_rate));
        current_statement__ = 62;
        lp_accum__.add(stan::math::gamma_lpdf<propto__>(sigma_rw1,
                         sigma_rw1_shape, sigma_rw1_rate));
        current_statement__ = 63;
        lp_accum__.add(stan::math::gamma_lpdf<propto__>(sigma_rw2,
                         sigma_rw2_shape, sigma_rw2_rate));
        current_statement__ = 64;
        lp_accum__.add(stan::math::sum(
                         stan::model::rvalue(log_lik, "log_lik",
                           stan::model::index_multi(obs_idx))));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_walker_lm_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> beta_fixed =
        Eigen::Matrix<double,-1,1>::Constant(k_fixed,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      beta_fixed = in__.template read<
                     Eigen::Matrix<local_scalar_t__,-1,1>>(k_fixed);
      std::vector<double> sigma_rw1 =
        std::vector<double>(k_rw1, std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 2;
      sigma_rw1 = in__.template read_constrain_lb<
                    std::vector<local_scalar_t__>, jacobian__>(0, lp__,
                    k_rw1);
      std::vector<double> sigma_rw2 =
        std::vector<double>(k_rw2, std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 3;
      sigma_rw2 = in__.template read_constrain_lb<
                    std::vector<local_scalar_t__>, jacobian__>(0, lp__,
                    k_rw2);
      double sigma_y = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 4;
      sigma_y = in__.template read_constrain_lb<local_scalar_t__,
                  jacobian__>(0, lp__);
      Eigen::Matrix<double,-1,1> log_lik =
        Eigen::Matrix<double,-1,1>::Constant(n,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,-1> Rt =
        Eigen::Matrix<double,-1,-1>::Constant(m, n,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> xbeta =
        Eigen::Matrix<double,-1,1>::Constant(n,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> y_ =
        Eigen::Matrix<double,-1,1>::Constant(n,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(beta_fixed);
      out__.write(sigma_rw1);
      out__.write(sigma_rw2);
      out__.write(sigma_y);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 6;
      stan::model::assign(Rt, stan::math::rep_matrix(0.0, m, n),
        "assigning variable Rt");
      current_statement__ = 17;
      if (stan::math::logical_gt(k_fixed, 0)) {
        current_statement__ = 15;
        stan::model::assign(xbeta,
          stan::math::multiply(xreg_fixed, beta_fixed),
          "assigning variable xbeta");
      } else {
        current_statement__ = 13;
        stan::model::assign(xbeta, stan::math::rep_vector(0.0, n),
          "assigning variable xbeta");
      }
      current_statement__ = 18;
      stan::model::assign(y_, stan::math::subtract(y, xbeta),
        "assigning variable y_");
      current_statement__ = 26;
      for (int t = 1; t <= n; ++t) {
        current_statement__ = 21;
        for (int i = 1; i <= k_rw1; ++i) {
          current_statement__ = 19;
          stan::model::assign(Rt,
            stan::math::pow(
              (stan::model::rvalue(gamma_rw1, "gamma_rw1",
                 stan::model::index_uni(i), stan::model::index_uni(t)) *
              stan::model::rvalue(sigma_rw1, "sigma_rw1",
                stan::model::index_uni(i))), 2), "assigning variable Rt",
            stan::model::index_uni(i), stan::model::index_uni(t));
        }
        current_statement__ = 24;
        for (int i = 1; i <= k_rw2; ++i) {
          current_statement__ = 22;
          stan::model::assign(Rt,
            stan::math::pow(
              (stan::model::rvalue(gamma_rw2, "gamma_rw2",
                 stan::model::index_uni(i), stan::model::index_uni(t)) *
              stan::model::rvalue(sigma_rw2, "sigma_rw2",
                stan::model::index_uni(i))), 2), "assigning variable Rt",
            stan::model::index_uni((k + i)), stan::model::index_uni(t));
        }
      }
      current_statement__ = 27;
      stan::model::assign(log_lik,
        gaussian_filter(y_, y_miss, a1, P1, stan::math::pow(sigma_y, 2), Tt,
          Rt, xreg_rw, gamma2_y, pstream__), "assigning variable log_lik");
      if (emit_transformed_parameters__) {
        out__.write(log_lik);
        out__.write(Rt);
        out__.write(xbeta);
        out__.write(y_);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      Eigen::Matrix<double,-1,1> y_rep =
        Eigen::Matrix<double,-1,1>::Constant(y_rep_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,-1> beta_rw =
        Eigen::Matrix<double,-1,-1>::Constant(k, beta_rw_2dim__,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,-1> nu =
        Eigen::Matrix<double,-1,-1>::Constant(k_rw2, nu_2dim__,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> y_fit =
        Eigen::Matrix<double,-1,1>::Constant(y_fit_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 59;
      if (stan::math::logical_eq(n_lfo, n)) {
        current_statement__ = 30;
        for (int i = 1; i <= k_rw1; ++i) {
          current_statement__ = 28;
          stan::model::assign(beta_rw,
            stan::math::normal_rng(beta_rw1_mean, beta_rw1_sd, base_rng__),
            "assigning variable beta_rw", stan::model::index_uni(i),
            stan::model::index_uni(1));
        }
        current_statement__ = 34;
        for (int i = 1; i <= k_rw2; ++i) {
          current_statement__ = 31;
          stan::model::assign(beta_rw,
            stan::math::normal_rng(beta_rw2_mean, beta_rw2_sd, base_rng__),
            "assigning variable beta_rw",
            stan::model::index_uni((k_rw1 + i)), stan::model::index_uni(1));
          current_statement__ = 32;
          stan::model::assign(nu,
            stan::math::normal_rng(nu_mean, nu_sd, base_rng__),
            "assigning variable nu", stan::model::index_uni(i),
            stan::model::index_uni(1));
        }
        current_statement__ = 43;
        for (int t = 1; t <= (n - 1); ++t) {
          current_statement__ = 37;
          for (int i = 1; i <= k_rw1; ++i) {
            current_statement__ = 35;
            stan::model::assign(beta_rw,
              stan::math::normal_rng(
                stan::model::rvalue(beta_rw, "beta_rw",
                  stan::model::index_uni(i), stan::model::index_uni(t)),
                (stan::model::rvalue(gamma_rw1, "gamma_rw1",
                   stan::model::index_uni(i), stan::model::index_uni(t)) *
                stan::model::rvalue(sigma_rw1, "sigma_rw1",
                  stan::model::index_uni(i))), base_rng__),
              "assigning variable beta_rw", stan::model::index_uni(i),
              stan::model::index_uni((t + 1)));
          }
          current_statement__ = 41;
          for (int i = 1; i <= k_rw2; ++i) {
            current_statement__ = 38;
            stan::model::assign(beta_rw,
              (stan::model::rvalue(beta_rw, "beta_rw",
                 stan::model::index_uni((k_rw1 + i)),
                 stan::model::index_uni(t)) +
              stan::model::rvalue(nu, "nu", stan::model::index_uni(i),
                stan::model::index_uni(t))), "assigning variable beta_rw",
              stan::model::index_uni((k_rw1 + i)),
              stan::model::index_uni((t + 1)));
            current_statement__ = 39;
            stan::model::assign(nu,
              stan::math::normal_rng(
                stan::model::rvalue(nu, "nu", stan::model::index_uni(i),
                  stan::model::index_uni(t)),
                (stan::model::rvalue(gamma_rw2, "gamma_rw2",
                   stan::model::index_uni(i), stan::model::index_uni(t)) *
                stan::model::rvalue(sigma_rw2, "sigma_rw2",
                  stan::model::index_uni(i))), base_rng__),
              "assigning variable nu", stan::model::index_uni(i),
              stan::model::index_uni((t + 1)));
          }
        }
        current_statement__ = 46;
        for (int t = 1; t <= n; ++t) {
          current_statement__ = 44;
          stan::model::assign(y_rep,
            stan::math::normal_rng(
              stan::math::dot_product(
                stan::model::rvalue(xreg_rw, "xreg_rw",
                  stan::model::index_omni(), stan::model::index_uni(t)),
                stan::model::rvalue(beta_rw, "beta_rw",
                  stan::model::index_omni(), stan::model::index_uni(t))),
              (stan::model::rvalue(gamma_y, "gamma_y",
                 stan::model::index_uni(t)) * sigma_y), base_rng__),
            "assigning variable y_rep", stan::model::index_uni(t));
        }
        {
          current_statement__ = 47;
          stan::math::validate_non_negative_index("states", "m", m);
          current_statement__ = 48;
          stan::math::validate_non_negative_index("states", "n", n);
          Eigen::Matrix<double,-1,-1> states =
            Eigen::Matrix<double,-1,-1>::Constant(m, n,
              std::numeric_limits<double>::quiet_NaN());
          current_statement__ = 49;
          stan::model::assign(states,
            gaussian_smoother(stan::math::subtract(y_, y_rep), y_miss, a1,
              P1, stan::math::pow(sigma_y, 2), Tt, Rt, xreg_rw, gamma2_y,
              pstream__), "assigning variable states");
          current_statement__ = 50;
          stan::model::assign(beta_rw,
            stan::math::add(stan::model::deep_copy(beta_rw),
              stan::model::rvalue(states, "states",
                stan::model::index_min_max(1, k),
                stan::model::index_min_max(1, n))),
            "assigning variable beta_rw");
          current_statement__ = 52;
          if (stan::math::logical_gt(k_rw2, 0)) {
            current_statement__ = 51;
            stan::model::assign(nu,
              stan::math::add(stan::model::deep_copy(nu),
                stan::model::rvalue(states, "states",
                  stan::model::index_min_max((k + 1), m),
                  stan::model::index_min_max(1, n))), "assigning variable nu");
          }
        }
        current_statement__ = 57;
        for (int t = 1; t <= n; ++t) {
          current_statement__ = 54;
          stan::model::assign(y_fit,
            (stan::model::rvalue(xbeta, "xbeta", stan::model::index_uni(t)) +
            stan::math::dot_product(
              stan::model::rvalue(xreg_rw, "xreg_rw",
                stan::model::index_omni(), stan::model::index_uni(t)),
              stan::model::rvalue(beta_rw, "beta_rw",
                stan::model::index_omni(), stan::model::index_uni(t)))),
            "assigning variable y_fit", stan::model::index_uni(t));
          current_statement__ = 55;
          stan::model::assign(y_rep,
            stan::math::normal_rng(
              stan::model::rvalue(y_fit, "y_fit", stan::model::index_uni(t)),
              (stan::model::rvalue(gamma_y, "gamma_y",
                 stan::model::index_uni(t)) * sigma_y), base_rng__),
            "assigning variable y_rep", stan::model::index_uni(t));
        }
      }
      out__.write(y_rep);
      out__.write(beta_rw);
      out__.write(nu);
      out__.write(y_fit);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> beta_fixed =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(k_fixed, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(beta_fixed,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(k_fixed),
        "assigning variable beta_fixed");
      out__.write(beta_fixed);
      std::vector<local_scalar_t__> sigma_rw1 =
        std::vector<local_scalar_t__>(k_rw1, DUMMY_VAR__);
      current_statement__ = 2;
      stan::model::assign(sigma_rw1,
        in__.read<std::vector<local_scalar_t__>>(k_rw1),
        "assigning variable sigma_rw1");
      out__.write_free_lb(0, sigma_rw1);
      std::vector<local_scalar_t__> sigma_rw2 =
        std::vector<local_scalar_t__>(k_rw2, DUMMY_VAR__);
      current_statement__ = 3;
      stan::model::assign(sigma_rw2,
        in__.read<std::vector<local_scalar_t__>>(k_rw2),
        "assigning variable sigma_rw2");
      out__.write_free_lb(0, sigma_rw2);
      local_scalar_t__ sigma_y = DUMMY_VAR__;
      current_statement__ = 4;
      sigma_y = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, sigma_y);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "beta_fixed",
        "double", std::vector<size_t>{static_cast<size_t>(k_fixed)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "sigma_rw1",
        "double", std::vector<size_t>{static_cast<size_t>(k_rw1)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "sigma_rw2",
        "double", std::vector<size_t>{static_cast<size_t>(k_rw2)});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "sigma_y",
        "double", std::vector<size_t>{});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> beta_fixed =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(k_fixed, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> beta_fixed_flat__;
        current_statement__ = 1;
        beta_fixed_flat__ = context__.vals_r("beta_fixed");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= k_fixed; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(beta_fixed, beta_fixed_flat__[(pos__ - 1)],
            "assigning variable beta_fixed", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(beta_fixed);
      std::vector<local_scalar_t__> sigma_rw1 =
        std::vector<local_scalar_t__>(k_rw1, DUMMY_VAR__);
      current_statement__ = 2;
      sigma_rw1 = context__.vals_r("sigma_rw1");
      out__.write_free_lb(0, sigma_rw1);
      std::vector<local_scalar_t__> sigma_rw2 =
        std::vector<local_scalar_t__>(k_rw2, DUMMY_VAR__);
      current_statement__ = 3;
      sigma_rw2 = context__.vals_r("sigma_rw2");
      out__.write_free_lb(0, sigma_rw2);
      local_scalar_t__ sigma_y = DUMMY_VAR__;
      current_statement__ = 4;
      sigma_y = context__.vals_r("sigma_y")[(1 - 1)];
      out__.write_free_lb(0, sigma_y);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"beta_fixed", "sigma_rw1",
                "sigma_rw2", "sigma_y"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"log_lik", "Rt", "xbeta", "y_"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"y_rep", "beta_rw", "nu", "y_fit"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(
                                                                    k_fixed)},
                std::vector<size_t>{static_cast<size_t>(k_rw1)},
                std::vector<size_t>{static_cast<size_t>(k_rw2)},
                std::vector<size_t>{}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(n)},
             std::vector<size_t>{static_cast<size_t>(m),
               static_cast<size_t>(n)},
             std::vector<size_t>{static_cast<size_t>(n)},
             std::vector<size_t>{static_cast<size_t>(n)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(y_rep_1dim__)},
             std::vector<size_t>{static_cast<size_t>(k),
               static_cast<size_t>(beta_rw_2dim__)},
             std::vector<size_t>{static_cast<size_t>(k_rw2),
               static_cast<size_t>(nu_2dim__)},
             std::vector<size_t>{static_cast<size_t>(y_fit_1dim__)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= k_fixed; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta_fixed" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= k_rw1; ++sym1__) {
      param_names__.emplace_back(std::string() + "sigma_rw1" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= k_rw2; ++sym1__) {
      param_names__.emplace_back(std::string() + "sigma_rw2" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "sigma_y");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= m; ++sym2__) {
          param_names__.emplace_back(std::string() + "Rt" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        param_names__.emplace_back(std::string() + "xbeta" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        param_names__.emplace_back(std::string() + "y_" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= y_rep_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "y_rep" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= beta_rw_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
          param_names__.emplace_back(std::string() + "beta_rw" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= nu_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= k_rw2; ++sym2__) {
          param_names__.emplace_back(std::string() + "nu" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= y_fit_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "y_fit" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= k_fixed; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta_fixed" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= k_rw1; ++sym1__) {
      param_names__.emplace_back(std::string() + "sigma_rw1" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= k_rw2; ++sym1__) {
      param_names__.emplace_back(std::string() + "sigma_rw2" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "sigma_y");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= m; ++sym2__) {
          param_names__.emplace_back(std::string() + "Rt" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        param_names__.emplace_back(std::string() + "xbeta" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        param_names__.emplace_back(std::string() + "y_" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= y_rep_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "y_rep" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= beta_rw_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
          param_names__.emplace_back(std::string() + "beta_rw" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= nu_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= k_rw2; ++sym2__) {
          param_names__.emplace_back(std::string() + "nu" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= y_fit_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "y_fit" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"beta_fixed\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(k_fixed) + "},\"block\":\"parameters\"},{\"name\":\"sigma_rw1\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(k_rw1) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_rw2\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(k_rw2) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_y\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n) + "},\"block\":\"transformed_parameters\"},{\"name\":\"Rt\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(m) + ",\"cols\":" + std::to_string(n) + "},\"block\":\"transformed_parameters\"},{\"name\":\"xbeta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n) + "},\"block\":\"transformed_parameters\"},{\"name\":\"y_\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n) + "},\"block\":\"transformed_parameters\"},{\"name\":\"y_rep\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(y_rep_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"beta_rw\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(k) + ",\"cols\":" + std::to_string(beta_rw_2dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"nu\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(k_rw2) + ",\"cols\":" + std::to_string(nu_2dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"y_fit\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(y_fit_1dim__) + "},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"beta_fixed\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(k_fixed) + "},\"block\":\"parameters\"},{\"name\":\"sigma_rw1\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(k_rw1) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_rw2\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(k_rw2) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_y\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n) + "},\"block\":\"transformed_parameters\"},{\"name\":\"Rt\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(m) + ",\"cols\":" + std::to_string(n) + "},\"block\":\"transformed_parameters\"},{\"name\":\"xbeta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n) + "},\"block\":\"transformed_parameters\"},{\"name\":\"y_\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n) + "},\"block\":\"transformed_parameters\"},{\"name\":\"y_rep\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(y_rep_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"beta_rw\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(k) + ",\"cols\":" + std::to_string(beta_rw_2dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"nu\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(k_rw2) + ",\"cols\":" + std::to_string(nu_2dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"y_fit\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(y_fit_1dim__) + "},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((k_fixed + k_rw1) + k_rw2) + 1);
    const size_t num_transformed = emit_transformed_parameters * ((((n + (m *
      n)) + n) + n));
    const size_t num_gen_quantities = emit_generated_quantities *
      ((((y_rep_1dim__ + (k * beta_rw_2dim__)) + (k_rw2 * nu_2dim__)) +
      y_fit_1dim__));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((k_fixed + k_rw1) + k_rw2) + 1);
    const size_t num_transformed = emit_transformed_parameters * ((((n + (m *
      n)) + n) + n));
    const size_t num_gen_quantities = emit_generated_quantities *
      ((((y_rep_1dim__ + (k * beta_rw_2dim__)) + (k_rw2 * nu_2dim__)) +
      y_fit_1dim__));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_walker_lm_namespace::model_walker_lm;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_walker_lm_namespace::profiles__;
}
#endif
#endif
