% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dummies.R
\name{dummies}
\alias{dummies}
\title{Create Dummy Variables}
\usage{
dummies(input, vars)
}
\arguments{
\item{input}{data.frame with calibration variables}

\item{vars}{character vector with names of variables requiring dummy encoding}
}
\value{
data.frame with the new dummy variables
}
\description{
Create dummy variables of factors and character vectors in a data frame
}
\examples{
calVars <- c(
  "SEX_A_R", "AGEP_A_R", "HISPALLP_A_R", "ORIENT_A_R", "HICOV_A_R", "EDUCP_A_R", "REGION_R",
  "EMPLASTWK_A_R", "HOUTENURE_A_R", "MARITAL_A_R"
)
stuVars <- "DIBTYPE_A_R"
nhis_keep_vars <- c("PPSU","PSTRAT","WTFA_A")

# First impute
nhis_imputed <- impute_data(nhis_processed, c(calVars, stuVars), nhis_keep_vars)

# Then create dummy variables
nhis_vars_dummies <- c("AGEP_A_R","HISPALLP_A_R","EDUCP_A_R","REGION_R")
nhis_dummied <- dummies(nhis_imputed, vars=paste0(nhis_vars_dummies, '_I'))

}
