% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approxPot.R
\name{approxPot2D}
\alias{approxPot2D}
\title{Approximate potential in two dimensions}
\usage{
approxPot2D(f, xs, ys, V0 = "auto", mode = "mixed")
}
\arguments{
\item{f}{Two-dimensional representing the flow (right hand side of differential equation)}

\item{xs}{Vector xs positions to evaluate}

\item{ys}{Vector of ys positions to evaluate}

\item{V0}{(Optional) Value of V at first element of (xs,ys). When default, the global minimum is assigned 0}

\item{mode}{(Optional) Integration mode. Options are horizontal (default), vertical and mixed}
}
\value{
The potential estimated at each point (xs, ys)
}
\description{
Approximate potential in two dimensions
}
\examples{
# Flow
f = function(x) {c(-x[1]*(x[1]^2 - 1.1), -x[2]*(x[2]^2 - 1))}

# Sampling points
xs <- seq(-1.5, 1.5, length.out = 10)
ys <- seq(-1.5, 1.5, length.out = 15)

# Approximated potential
Vs <- approxPot2D(f, xs, ys, mode = 'horizontal')
}
\references{
\url{https://arxiv.org/abs/1903.05615}
}
\seealso{
\code{\link{approxPot1D}, \link{deltaV}}
}
\author{
Pablo Rodríguez-Sánchez (\url{https://pabrod.github.io})
}
