% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wdi_get_regions.R
\name{wdi_get_regions}
\alias{wdi_get_regions}
\title{Download regions from the World Bank API}
\source{
https://api.worldbank.org/v2/region
}
\usage{
wdi_get_regions(language = "en")
}
\arguments{
\item{language}{A character string specifying the language code for the API
response (default is "en" for English).}
}
\value{
A tibble with the following columns:
\describe{
\item{region_id}{An integer identifier for each region.}
\item{region_code}{A character string representing the region code.}
\item{region_iso2code}{A character string representing the ISO2 code for
the region.}
\item{region_name}{A character string representing the name of the region,
in the specified language.}
}
}
\description{
This function returns a tibble of supported regions for querying the World
Bank API.The regions include various geographic areas covered by the World
Bank's datasets.
}
\details{
This function provides a reference for the supported regions, which
are important for refining queries related to geographic data in the World
Bank's datasets. The \code{region_id} column is unique for seven key regions.
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
# Download all regions
wdi_get_regions()
\dontshow{\}) # examplesIf}
}
