% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpa_control.R
\name{rpa_control_preference}
\alias{rpa_control_preference}
\title{Set preference function(s). Defined for \code{rpanet}.}
\usage{
rpa_control_preference(
  ftype = c("default", "customized"),
  sparams = c(1, 1, 0, 0, 1),
  tparams = c(0, 0, 1, 1, 1),
  params = c(1, 1),
  spref = "outs + 1",
  tpref = "ins + 1",
  pref = "s + 1"
)
}
\arguments{
\item{ftype}{Preference function type. Either "default" or "customized".
"customized" preference functions require "binary" or "linear" generation
methods. If using default preference functions, \code{sparams},
\code{tparams} and \code{params} must be specified. If using customized
preference functions, \code{spref}, \code{tpref} and \code{pref} must be
specified.}

\item{sparams}{A numerical vector of length 5 giving the parameters of the
default source preference function. Defined for directed networks.
Probability of choosing an existing node as the source node is proportional
to \code{sparams[1] * out-strength^sparams[2] + sparams[3] *
in-strength^sparams[4] + sparams[5]}.}

\item{tparams}{A numerical vector of length 5 giving the parameters of the
default target preference function. Defined for directed networks.
Probability of choosing an existing node as the target node is proportional
to \code{tparams[1] * out-strength^tparams[2] + tparams[3] *
in-strength^tparams[4] + tparams[5]}.}

\item{params}{A numerical vector of length 2 giving the parameters of the
default preference function. Defined for undirected networks. Probability
of choosing an existing node is proportional to \code{strength^params[1] +
params[2].}}

\item{spref}{Character expression or an object of class \code{XPtr} giving
the customized source preference function. Defined for directed networks.
Default value is \code{"outs + 1"}, i.e., node out-strength + 1. See
Details and Examples for more information.}

\item{tpref}{Character expression or an object of class \code{XPtr} giving
the customized target preference function. Defined for directed networks.
Default value is \code{"ins + 1"}, i.e., node in-strength + 1.}

\item{pref}{Character expression or an object of class \code{XPtr} giving the
customized preference function. Defined for undirected networks. Default
value is \code{"s + 1"}, i.e, node strength + 1.}
}
\value{
A list of class \code{rpacontrol} with components \code{ftype},
  \code{sparams}, \code{tparams}, \code{params} or \code{ftype},
  \code{spref}, \code{tpref}, \code{pref} with function pointers
  \code{spref.pointer}, \code{tpref.pointer}, \code{pref.pointer}.
}
\description{
Set preference function(s). Defined for \code{rpanet}.
}
\details{
If choosing customized preference functions, \code{spref},
  \code{tpref} and \code{pref} will be used and the network generation method
  must be "binary" or "linear". \code{spref} (\code{tpref}) defines the
  source (target) preference function, it can be a character expression or an
  object of class \code{XPtr}. \itemize{ \item Character expression; it
  must be a one-line \code{C++} style expression of \code{outs}
  (node out-strength) and
  \code{ins} (node in-strength). For example, \code{"pow(outs, 2) + 1"},
  \code{"pow(outs, 2) + pow(ins, 2) + 1"}, etc. The expression will be used
  to define an \code{XPtr} via \code{RcppXPtrUtils::cppXPtr}. The \code{XPtr}
  will be passed to the network generation function. The expression must not
  have variables other than \code{outs} and \code{ins}. \item `XPtr` an 
  external pointer wrapped in an object of class \code{XPtr} defined via
  \code{RcppXPtrUtils::cppXPtr}. An example for defining an \code{XPtr} with
  \code{C++} source code is included in Examples. For more information
  about passing function pointers, see
  \url{https://gallery.rcpp.org/articles/passing-cpp-function-pointers-rcppxptrutils/}.
  Please note the supplied \code{C++} function accepts two \code{double}
  arguments and returns a \code{double}. The first and second arguments
  represent node out- and in-strength, respectively. Note that the \code{XPtr} will
  be invalid and cannot be used to control network generation
  in another separate R session. Therefore, we recommend preserving the source code of your
  preference function for future use.}

  \code{pref} is defined analogously. If using character expression, it must
  be a one-line \code{C++} style expression of \code{s} (node strength). If
  using \code{XPtr}, the supplied \code{C++} function accepts only one
  \code{double} argument and returns a \code{double}.
}
\examples{
\donttest{
# Set source preference as out-strength^2 + in-strength + 1,
# target preference as out-strength + in-strength^2 + 1.
# 1. use default preference functions
ctr1 <- rpa_control_preference(
  ftype = "default",
  sparams = c(1, 2, 1, 1, 1), tparams = c(1, 1, 1, 2, 1)
)
# 2. use character expressions
ctr2 <- rpa_control_preference(
  ftype = "customized",
  spref = "pow(outs, 2) + ins + 1", tpref = "outs + pow(ins, 2) + 1"
)
# 3. define XPtr's with C++ source code
spref.pointer <- RcppXPtrUtils::cppXPtr(
  code =
    "double spref(double outs, double ins) {return pow(outs, 2) + ins + 1;}"
)
tpref.pointer <- RcppXPtrUtils::cppXPtr(
  code =
    "double tpref(double outs, double ins) {return outs + pow(ins, 2) + 1;}"
)
ctr3 <- rpa_control_preference(
  ftype = "customized",
  spref = spref.pointer,
  tpref = tpref.pointer
)
ret <- rpanet(1e5, control = ctr3)
}
}
