% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dpird_availability.R
\name{get_dpird_availability}
\alias{get_dpird_availability}
\title{Get the Availability for DPIRD Weather Stations}
\usage{
get_dpird_availability(
  station_code = NULL,
  start_date = NULL,
  end_date = NULL,
  values = "availability",
  api_key = get_key(service = "DPIRD")
)
}
\arguments{
\item{station_code}{A \code{character} string of the \acronym{DPIRD} station code
for the station of interest. Defaults to \code{NULL}, returning metadata for
all stations during the requested \var{start_date} and \var{end_date}
interval.}

\item{start_date}{A \code{character} string representing the beginning of the
range to query in the format \dQuote{yyyy-mm-dd} (ISO8601).  This function
will return data inclusive of this date.  Defaults to \code{NULL}, returning
data for the current year-to-date.  Must be sent along with an
\var{end_date}.}

\item{end_date}{A \code{character} string representing the end of the range query
in the format \dQuote{yyyy-mm-dd} (ISO8601).  This function will return
data inclusive of this date.  Defaults to \code{NULL}, returning data for the
current year-to-date.  Must be sent with a \var{start_date}.}

\item{values}{A \code{character} string with the type of availability metadata to
return.  See \strong{Available Values} for a full list of valid values.
Defaults to \code{availability}, returning metadata for all stations.}

\item{api_key}{A \code{character} string containing your \acronym{API} key from
\acronym{DPIRD}, \url{https://www.dpird.wa.gov.au/online-tools/apis/}, for the
\acronym{DPIRD} Weather 2.0 \acronym{API}.  Defaults to automatically
detecting your key from your local .Renviron, .Rprofile or similar.
Alternatively, you may directly provide your key as a string here.  If
nothing is provided, you will be prompted on how to set up your R session
so that it is auto-detected.}
}
\value{
a \code{\link[data.table:data.table]{data.table::data.table()}}  with \code{station_code} and the requested
metadata.
}
\description{
Fetch the availability metadata of weather stations in the \acronym{DPIRD}
weather station network from the Weather 2.0 \acronym{API}.
}
\section{Available Values}{

\itemize{
\item availability (which will return all of the following values),
\item availabilityCurrentHour,
\item availabilityLast7DaysSince9AM,
\item availabilityLast7DaysSince12AM,
\item availabilityLast14DaysSince9AM,
\item availabilityLast14DaysSince12AM,
\item availabilityLast24Hours,
\item availabilityMonthToDateSince12AM,
\item availabilityMonthToDateTo9AM,
\item availabilitySince9AM,
\item availabilitySince12AM,
\item availabilityTo9AM,
\item availabilityYearToDateSince12AM, and
\item availabilityYearToDateTo9AM
}
}

\examples{
\dontrun{
# Note that you need to supply your own API key

# Here we check the up time for the current year for Westonia
WS001 <- get_dpird_availability(station_code = "WS001",
                                api_key = "your_api_key")

# Here we check the up time for 2017 for Binnu
BN <- get_dpird_availability(
  station_code = "BI",
  start_date = "20170101",
  end_date = "20171231",
  api_key = "your_api_key"
)
}

}
\seealso{
Other DPIRD: 
\code{\link{dpird_extreme_weather_values}},
\code{\link{dpird_minute_values}},
\code{\link{dpird_summary_values}},
\code{\link{find_nearby_stations}()},
\code{\link{find_stations_in}()},
\code{\link{get_dpird_apsim}()},
\code{\link{get_dpird_extremes}()},
\code{\link{get_dpird_minute}()},
\code{\link{get_dpird_summaries}()},
\code{\link{get_stations_metadata}()}

Other metadata: 
\code{\link{find_forecast_towns}()},
\code{\link{find_nearby_stations}()},
\code{\link{find_stations_in}()},
\code{\link{get_available_imagery}()},
\code{\link{get_available_radar}()},
\code{\link{get_stations_metadata}()}
}
\author{
Adam H. Sparks, \email{adamhsparks@gmail.com}
}
\concept{DPIRD}
\concept{metadata}
