% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotG.R
\name{plotG}
\alias{plotG}
\title{Plots the metaweb G}
\usage{
plotG(tSDM)
}
\arguments{
\item{tSDM}{A trophicSDMfit object obtained with trophicSDM()}
}
\value{
A ggnet object
}
\description{
Plots the metaweb G used to fit the trophicSDM model
}
\examples{
data(Y, X, G)
# define abiotic part of the model
env.formula = "~ X_1 + X_2"
# Run the model with bottom-up control using stan_glm as fitting method and no penalisation
# (set iter = 1000 to obtain reliable results)
m = trophicSDM(Y, X, G, env.formula, iter = 100,
               family = binomial(link = "logit"), penal = NULL, 
               mode = "prey", method = "stan_glm")
\donttest{
plotG(m)
}
}
\author{
Giovanni Poggiato
}
