% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webshot.R
\name{webshot}
\alias{webshot}
\title{Take a screenshot of a URL}
\usage{
webshot(
  url = NULL,
  file = "webshot.png",
  vwidth = 992,
  vheight = 744,
  selector = NULL,
  cliprect = NULL,
  expand = NULL,
  delay = 0.2,
  zoom = 1,
  useragent = NULL,
  max_concurrent = getOption("webshot.concurrent", default = 6),
  quiet = getOption("webshot.quiet", default = FALSE)
)
}
\arguments{
\item{url}{A vector of URLs to visit. If multiple URLs are provided, it will
load and take screenshots of those web pages in parallel.}

\item{file}{A vector of names of output files. Should end with an image file
type (\code{.png}, \code{.jpg}, \code{.jpeg}, or \code{.webp}) or
\code{.pdf}. If several screenshots have to be taken and only one filename
is provided, then the function appends the index number of the screenshot
to the file name. For PDF output, it is just like printing the page to PDF
in a browser; \code{selector}, \code{cliprect}, \code{expand}, and
\code{zoom} will not be used for PDFs.}

\item{vwidth, vheight}{Viewport width and height. This is the width or height
of the virtual browser "window". Chrome expects integer values; numeric
values are rounded to the nearest integer.}

\item{selector}{One or more CSS selectors specifying a DOM element to set the
clipping rectangle to. The screenshot will contain these DOM elements. For
a given selector, if it has more than one match, all matching elements will
be used. This option is not compatible with \code{cliprect}.

When taking screenshots of multiple URLs, this parameter can also be a list
with same length as \code{url} with each element of the list containing a
vector of CSS selectors to use for the corresponding URL.}

\item{cliprect}{Clipping rectangle. If \code{cliprect} and \code{selector}
are both unspecified, the clipping rectangle will contain the entire page.
This can be the string \code{"viewport"}, in which case the clipping
rectangle matches the viewport size, or it can be a four-element numeric
vector specifying the left, top, width, and height. (Note that the order of
left and top is reversed from the original webshot package.) This option is
not compatible with \code{selector}.

When taking screenshots of multiple URLs, this parameter can also be a list
with same length as \code{url} with each element of the list being
"viewport" or a four-elements numeric vector.}

\item{expand}{A numeric vector specifying how many pixels to expand beyond
the clipping rectangle determined by \code{selector}. If one number, the
rectangle will be expanded by that many pixels on all sides. If four
numbers, they specify the top, right, bottom, and left, in that order.
This argument is only applied when \code{selector} is used and is not compatible
with \code{cliprect}.

When taking screenshots of multiple URLs, this parameter can also be a list
with same length as \code{url} with each element of the list containing a
single number or four numbers to use for the corresponding URL.}

\item{delay}{Time to wait before taking screenshot, in seconds. Sometimes a
longer delay is needed for all assets to display properly.}

\item{zoom}{A number specifying the zoom factor. A zoom factor of 2 will
result in twice as many pixels vertically and horizontally. Note that using
2 is not exactly the same as taking a screenshot on a HiDPI (Retina)
device: it is like increasing the zoom to 200\% in a desktop browser and
doubling the height and width of the browser window. This differs from
using a HiDPI device because some web pages load different,
higher-resolution images when they know they will be displayed on a HiDPI
device (but using zoom will not report that there is a HiDPI device).}

\item{useragent}{The User-Agent header used to request the URL.}

\item{max_concurrent}{(Currently not implemented)}

\item{quiet}{If \code{TRUE}, status updates via console messages are suppressed.}
}
\value{
Invisibly returns the normalized path to all screenshots taken. The
character vector will have a class of \code{"webshot"}.
}
\description{
Take a screenshot of a URL
}
\examples{
if (interactive()) {

# Whole web page
webshot("https://github.com/rstudio/shiny")

# Might need a delay for all assets to display
webshot("http://rstudio.github.io/leaflet", delay = 0.5)

# One can also take screenshots of several URLs with only one command.
# This is more efficient than calling 'webshot' multiple times.
webshot(c("https://github.com/rstudio/shiny",
          "http://rstudio.github.io/leaflet"),
        delay = 0.5)

# Clip to the viewport
webshot("http://rstudio.github.io/leaflet", "leaflet-viewport.png",
        cliprect = "viewport")

# Specific size
webshot("https://www.r-project.org", vwidth = 1600, vheight = 900,
        cliprect = "viewport")

# Manual clipping rectangle
webshot("http://rstudio.github.io/leaflet", "leaflet-clip.png",
        cliprect = c(200, 5, 400, 300))

# Using CSS selectors to pick out regions
webshot("http://rstudio.github.io/leaflet", "leaflet-menu.png", selector = ".list-group")
# With multiple selectors, the screenshot will contain all selected elements
webshot("http://reddit.com/", "reddit-top.png",
        selector = c("[aria-label='Home']", "input[type='search']"))

# Expand selection region
webshot("http://rstudio.github.io/leaflet", "leaflet-boxes.png",
        selector = "#installation", expand = c(10, 50, 0, 50))

# If multiple matches for a given selector, it will take a screenshot that
# contains all matching elements.
webshot("http://rstudio.github.io/leaflet", "leaflet-p.png", selector = "p")
webshot("https://github.com/rstudio/shiny/", "shiny-stats.png",
         selector = "ul.numbers-summary")

# Result can be piped to other commands like resize() and shrink()
webshot("https://www.r-project.org/", "r-small.png") \%>\%
 resize("75\%") \%>\%
 shrink()

}

}
