% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/located_in_box.R
\name{located_in_box}
\alias{located_in_box}
\title{Locations In the Box}
\usage{
located_in_box(
  .,
  lat_column = "lat",
  lng_column = "lng",
  top_left_lat,
  top_left_lng,
  bottom_right_lat,
  bottom_right_lng
)
}
\arguments{
\item{.}{Data Frame that has been locationized. see \code{weed::split_locations}}

\item{lat_column}{Name of column containing Latitude data}

\item{lng_column}{Name of column containing Longitude data}

\item{top_left_lat}{Latitude at top left corner of box}

\item{top_left_lng}{Longitude at top left corner of box}

\item{bottom_right_lat}{Latitude at bottom right corner of box}

\item{bottom_right_lng}{Longitude at bottom right corner of box}
}
\value{
A dataframe that contains the latlong box data
}
\description{
Creates a new column (in_box) that tells whether the lat/long is in a certain box or not.
}
\examples{
d <- tibble::tribble(
~value,  ~location_word,                    ~Country,     ~lat,       ~lng,
"city of new york",      "new york",                       "USA", 40.71427,  -74.00597,
"kerala, chennai municipality, and san francisco",  "kerala", "India", 10.41667,       76.5,
"kerala, chennai municipality, and san francisco",  "chennai",  "India", 13.08784,   80.27847)
located_in_box(d, lat_column = "lat",
lng_column = "lng",
top_left_lat = 45,
bottom_right_lat = 12,
top_left_lng = -80,
bottom_right_lng = 90)
}
