% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_leaders.R
\name{wnba_homepagev2}
\alias{wnba_homepagev2}
\title{\strong{Get WNBA Stats API HomepageV2 Leaders}}
\usage{
wnba_homepagev2(
  league_id = "10",
  game_scope = "Season",
  player_or_team = "Team",
  player_scope = "All Players",
  season = most_recent_wnba_season() - 1,
  season_type = "Regular Season",
  stat_type = "Traditional",
  ...
)
}
\arguments{
\item{league_id}{League - default: '00'. Other options include '10': WWNBA, '20': G-League}

\item{game_scope}{Game Scope - Season, Last 10, ,Yesterday, Finals}

\item{player_or_team}{Player or Team}

\item{player_scope}{Player Scope - All Players, Rookies}

\item{season}{Season - format 2020-21}

\item{season_type}{Season Type - Regular Season, Playoffs}

\item{stat_type}{Stat Type - Traditional, Advanced, Tracking}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: HomePageStat1, HomePageStat2, HomePageStat3,
HomePageStat4, HomePageStat5, HomePageStat6, HomePageStat7, HomePageStat8

\strong{HomePageStat1}\tabular{ll}{
   col_name \tab types \cr
   RANK \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_NAME \tab character \cr
   PTS \tab character \cr
}


\strong{HomePageStat2}\tabular{ll}{
   col_name \tab types \cr
   RANK \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_NAME \tab character \cr
   REB \tab character \cr
}


\strong{HomePageStat3}\tabular{ll}{
   col_name \tab types \cr
   RANK \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_NAME \tab character \cr
   AST \tab character \cr
}


\strong{HomePageStat4}\tabular{ll}{
   col_name \tab types \cr
   RANK \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_NAME \tab character \cr
   STL \tab character \cr
}


\strong{HomePageStat5}\tabular{ll}{
   col_name \tab types \cr
   RANK \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_NAME \tab character \cr
   FG_PCT \tab character \cr
}


\strong{HomePageStat6}\tabular{ll}{
   col_name \tab types \cr
   RANK \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_NAME \tab character \cr
   FT_PCT \tab character \cr
}


\strong{HomePageStat7}\tabular{ll}{
   col_name \tab types \cr
   RANK \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_NAME \tab character \cr
   FG3_PCT \tab character \cr
}


\strong{HomePageStat8}\tabular{ll}{
   col_name \tab types \cr
   RANK \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_NAME \tab character \cr
   BLK \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API HomepageV2 Leaders}

\strong{Get WNBA Stats API HomepageV2 Leaders}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ wnba_homepagev2(league_id = '10', player_or_team = "Player")
 wnba_homepagev2(league_id = '10', player_or_team = "Team")
}\if{html}{\out{</div>}}
}
\author{
Saiem Gilani
}
\keyword{internal}
