
test_that("ESPN - WNBA Player Stats", {
  skip_on_cran()
  x <- espn_wnba_player_stats(athlete_id = 2529130, year = 2022)
  cols <- c(
    "athlete_id",
    "athlete_uid",
    "athlete_guid",
    "athlete_type",
    "sdr",
    "first_name",
    "last_name",
    "full_name",
    "display_name",
    "short_name",
    "weight",
    "display_weight",
    "height",
    "display_height",
    "age",
    "date_of_birth",
    "slug",
    "headshot_href",
    "headshot_alt",
    "position_id",
    "position_name",
    "position_display_name",
    "position_abbreviation",
    "position_leaf",
    "linked",
    "years",
    "active",
    "status_id",
    "status_name",
    "status_type",
    "status_abbreviation",
    "defensive_blocks",
    "defensive_defensive_rebounds",
    "defensive_steals",
    "defensive_avg_defensive_rebounds",
    "defensive_avg_blocks",
    "defensive_avg_steals",
    "defensive_avg48defensive_rebounds",
    "defensive_avg48blocks",
    "defensive_avg48steals",
    "general_disqualifications",
    "general_flagrant_fouls",
    "general_fouls",
    "general_ejections",
    "general_technical_fouls",
    "general_rebounds",
    "general_vorp",
    "general_minutes",
    "general_avg_minutes",
    "general_fantasy_rating",
    "general_nba_rating",
    "general_plus_minus",
    "general_avg_rebounds",
    "general_avg_fouls",
    "general_avg_flagrant_fouls",
    "general_avg_technical_fouls",
    "general_avg_ejections",
    "general_avg_disqualifications",
    "general_assist_turnover_ratio",
    "general_steal_foul_ratio",
    "general_block_foul_ratio",
    "general_avg_team_rebounds",
    "general_total_rebounds",
    "general_total_technical_fouls",
    "general_team_assist_turnover_ratio",
    "general_steal_turnover_ratio",
    "general_avg48rebounds",
    "general_avg48fouls",
    "general_avg48flagrant_fouls",
    "general_avg48technical_fouls",
    "general_avg48ejections",
    "general_avg48disqualifications",
    "general_games_played",
    "general_games_started",
    "general_double_double",
    "general_triple_double",
    "offensive_assists",
    "offensive_field_goals",
    "offensive_field_goals_attempted",
    "offensive_field_goals_made",
    "offensive_field_goal_pct",
    "offensive_free_throws",
    "offensive_free_throw_pct",
    "offensive_free_throws_attempted",
    "offensive_free_throws_made",
    "offensive_offensive_rebounds",
    "offensive_points",
    "offensive_turnovers",
    "offensive_three_point_pct",
    "offensive_three_point_field_goals_attempted",
    "offensive_three_point_field_goals_made",
    "offensive_total_turnovers",
    "offensive_points_in_paint",
    "offensive_brick_index",
    "offensive_avg_field_goals_made",
    "offensive_avg_field_goals_attempted",
    "offensive_avg_three_point_field_goals_made",
    "offensive_avg_three_point_field_goals_attempted",
    "offensive_avg_free_throws_made",
    "offensive_avg_free_throws_attempted",
    "offensive_avg_points",
    "offensive_avg_offensive_rebounds",
    "offensive_avg_assists",
    "offensive_avg_turnovers",
    "offensive_offensive_rebound_pct",
    "offensive_estimated_possessions",
    "offensive_avg_estimated_possessions",
    "offensive_points_per_estimated_possessions",
    "offensive_avg_team_turnovers",
    "offensive_avg_total_turnovers",
    "offensive_three_point_field_goal_pct",
    "offensive_two_point_field_goals_made",
    "offensive_two_point_field_goals_attempted",
    "offensive_avg_two_point_field_goals_made",
    "offensive_avg_two_point_field_goals_attempted",
    "offensive_two_point_field_goal_pct",
    "offensive_shooting_efficiency",
    "offensive_scoring_efficiency",
    "offensive_avg48field_goals_made",
    "offensive_avg48field_goals_attempted",
    "offensive_avg48three_point_field_goals_made",
    "offensive_avg48three_point_field_goals_attempted",
    "offensive_avg48free_throws_made",
    "offensive_avg48free_throws_attempted",
    "offensive_avg48points",
    "offensive_avg48offensive_rebounds",
    "offensive_avg48assists",
    "offensive_avg48turnovers",
    "team_id",
    "team_guid",
    "team_uid",
    "team_sdr",
    "team_slug",
    "team_location",
    "team_name",
    "team_abbreviation",
    "team_display_name",
    "team_short_display_name",
    "team_color",
    "team_alternate_color",
    "team_is_active",
    "team_is_all_star",
    "logo_href",
    "logo_dark_href"
  )
  
  expect_in(sort(cols), sort(colnames(x)))
  expect_s3_class(x, "data.frame")
})
