% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay_distributions.R
\name{dist_delay}
\alias{dist_delay}
\alias{dist_delay.wt_mcs_delay_data}
\title{Parameter Estimation of a Delay Distribution}
\usage{
dist_delay(...)

\method{dist_delay}{wt_mcs_delay_data}(..., x, distribution = c("lognormal", "exponential"))
}
\arguments{
\item{...}{Further arguments passed to or from other methods. Currently not used.}

\item{x}{A \code{tibble} with class \code{wt_mcs_delay_data} returned by \link{mcs_delay_data}.}

\item{distribution}{Supposed distribution of the respective delay.}
}
\value{
A list with class \code{wt_delay_estimation} which contains:
\itemize{
\item \code{coefficients} : A named vector of estimated parameter(s).
\item \code{delay} : A numeric vector of element-wise computed differences in days.
\item \code{distribution} : Specified distribution.
}

If more than one delay was considered in \link{mcs_delay_data}, the resulting output
is a list with class \code{wt_delay_estimation_list}. In this case each list element
has class \code{wt_delay_estimation} and the items listed above, are included.
}
\description{
This function models a delay (in days) random variable (e.g. in logistic,
registration, report) using a supposed continuous distribution. First, the
row-wise differences in days of the related date columns are calculated and then
the parameter(s) of the assumed distribution is (are) estimated with maximum
likelihood. See 'Details' for more information.
}
\details{
The distribution parameter(s) is (are) determined on the basis of complete
cases, i.e. there is no \code{NA} (row-wise) in one of the related date columns.
Time differences less than or equal to zero are not considered as well.
}
\examples{
# MCS data preparation:
## Data for delay in registration:
mcs_tbl_1 <- mcs_delay_data(
  field_data,
  date_1 = production_date,
  date_2 = registration_date,
  time = dis,
  status = status,
  id = vin
)

## Data for delay in report:
mcs_tbl_2 <- mcs_delay_data(
  field_data,
  date_1 = repair_date,
  date_2 = report_date,
  time = dis,
  status = status,
  id = vin
)

## Data for both delays:
mcs_tbl_both <- mcs_delay_data(
  field_data,
  date_1 = c(production_date, repair_date),
  date_2 = c(registration_date, report_date),
  time = dis,
  status = status,
  id = vin
)

# Example 1 - Delay in registration:
params_delay_regist  <- dist_delay(
  x = mcs_tbl_1,
  distribution = "lognormal"
)

# Example 2 - Delay in report:
params_delay_report  <- dist_delay(
  x = mcs_tbl_2,
  distribution = "exponential"
)

# Example 3 - Delays in registration and report with same distribution:
params_delays  <- dist_delay(
  x = mcs_tbl_both,
  distribution = "lognormal"
)

# Example 4 - Delays in registration and report with different distributions:
params_delays_2  <- dist_delay(
  x = mcs_tbl_both,
  distribution = c("lognormal", "exponential")
)

}
