% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcs_delay.R
\name{mcs_delay_register}
\alias{mcs_delay_register}
\title{Adjustment of Operating Times by Delays in Registration using a Monte Carlo
Approach}
\usage{
mcs_delay_register(
  date_prod,
  date_register,
  time,
  status,
  distribution = "lognormal",
  details = FALSE
)
}
\arguments{
\item{date_prod}{A vector of class \code{character} or \code{Date}, in the
format "yyyy-mm-dd", indicating the date of production of a unit.
Use \code{NA} for missing elements.}

\item{date_register}{A vector of class \code{character} or \code{Date}, in
the format "yyyy-mm-dd", indicating the date of registration of a unit.
Use \code{NA} for missing elements.}

\item{time}{A numeric vector of operating times.}

\item{status}{A vector of binary data (0 or 1) indicating whether unit \emph{i} is
a right censored observation (= 0) or a failure (= 1).}

\item{distribution}{Supposed distribution of the random variable. Only
\code{"lognormal"} is implemented.}

\item{details}{A logical. If \code{FALSE} the output consists of a vector with
corrected operating times for the censored units and the input operating
times for the failed units. If \code{TRUE} the output consists of a detailed
list, i.e the same vector as described before, simulated random numbers and
estimated distribution parameters.}
}
\value{
A numeric vector of corrected operating times for the censored units
and the input operating times for the failed units if \code{details = FALSE}.
If \code{details = TRUE} the output is a list which consists of the following elements:
\itemize{
\item \code{time} : Numeric vector of corrected operating times for the censored
observations and input operating times for failed units.
\item \code{x_sim} : Simulated random numbers of specified distribution with estimated
parameters. The length of \code{x_sim} is equal to the number of censored observations.
\item \code{coefficients} : Estimated coefficients of supposed distribution.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#soft-deprecated}{\figure{lifecycle-soft-deprecated.svg}{options: alt='[Soft-deprecated]'}}}{\strong{[Soft-deprecated]}}

\code{mcs_delay_register()} is no longer under active development, switching
to \link{mcs_delay} is recommended.
}
\details{
In general the amount of information about units in the field, that have not
failed yet, are rare. For example it is common that a supplier, who provides
parts to the automotive industry does not know when a vehicle was put in
service and therefore does not know the exact operating time of the supplied
parts. This function uses a Monte Carlo approach for simulating the operating
times of (multiple) right censored observations, taking account of registering
delays. The simulation is based on the distribution of operating times that were
calculated from complete data (see \link{dist_delay_register}).
}
\examples{
date_of_production   <- c("2014-07-28", "2014-02-17", "2014-07-14",
                          "2014-06-26", "2014-03-10", "2014-05-14",
                          "2014-05-06", "2014-03-07", "2014-03-09",
                          "2014-04-13", "2014-05-20", "2014-07-07",
                          "2014-01-27", "2014-01-30", "2014-03-17",
                          "2014-02-09", "2014-04-14", "2014-04-20",
                          "2014-03-13", "2014-02-23", "2014-04-03",
                          "2014-01-08", "2014-01-08")
date_of_registration <- c(NA, "2014-03-29", "2014-12-06", "2014-09-09",
                          NA, NA, "2014-06-16", NA, "2014-05-23",
                          "2014-05-09", "2014-05-31", NA, "2014-04-13",
                          NA, NA, "2014-03-12", NA, "2014-06-02",
                          NA, "2014-03-21", "2014-06-19", NA, NA)

op_time <- rep(1000, length(date_of_production))
status <- c(0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 1, 0, 0)

# Example 1 - Simplified vector output:
x_corrected <- mcs_delay_register(
  date_prod = date_of_production,
  date_register = date_of_registration,
  time = op_time,
  status = status,
  distribution = "lognormal",
  details = FALSE
)

# Example 2 - Detailed list output:
list_detail <- mcs_delay_register(
  date_prod = date_of_production,
  date_register = date_of_registration,
  time = op_time,
  status = status,
  distribution = "lognormal",
  details = TRUE
)

}
