% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcs_mileage.R
\name{mcs_mileage}
\alias{mcs_mileage}
\alias{mcs_mileage.wt_mcs_mileage_data}
\title{Simulation of Unknown Covered Distances using a Monte Carlo Approach}
\usage{
mcs_mileage(x, ...)

\method{mcs_mileage}{wt_mcs_mileage_data}(x, distribution = c("lognormal", "exponential"), ...)
}
\arguments{
\item{x}{A \code{tibble} of class \code{wt_mcs_mileage_data} returned by \link{mcs_mileage_data}.}

\item{...}{Further arguments passed to or from other methods. Currently not used.}

\item{distribution}{Supposed distribution of the annual mileage.}
}
\value{
A list with class \code{wt_mcs_mileage} containing the following elements:
\itemize{
\item \code{data} : A \code{tibble} returned by \link{mcs_mileage_data} where two modifications
has been made:
\itemize{
\item If the column \code{status} exists, the \code{tibble} has additional classes
\code{wt_mcs_data} and \code{wt_reliability_data}. Otherwise, the \code{tibble} only has
the additional class \code{wt_mcs_data} (which is not supported by \link{estimate_cdf}).
\item The column \code{mileage} is renamed to \code{x} (to be in accordance with
\link{reliability_data}) and contains simulated distances for incomplete
observations and input distances for the complete observations.
}
\item \code{sim_data} : A \code{tibble} with column \code{sim_mileage} that holds the simulated
distances for incomplete cases and \code{0} for complete cases.
\item \code{model_estimation} : A list returned by \link{dist_mileage}.
}
}
\description{
This function simulates distances for units where these are unknown.

First, random numbers of the annual mileage distribution, estimated by
\link{dist_mileage}, are drawn. Second, the drawn annual distances are
converted with respect to the actual operating times (in days) using a linear
relationship. See 'Details'.
}
\details{
\strong{Assumption of linear relationship}: Imagine the distance of the vehicle
is unknown. A distance of 3500.25 kilometers (km) was drawn from the annual
distribution and the known operating time is 200 days (d). So the resulting
distance of this vehicle is
\deqn{3500.25 km \cdot (\frac{200 d} {365 d}) = 1917.945 km}{%
3500.25 km * (200 d / 365 d) = 1917.945 km}
}
\examples{
# MCS data preparation:
mcs_tbl <- mcs_mileage_data(
  field_data,
  mileage = mileage,
  time = dis,
  status = status,
  id = vin
)

# Example 1 - Reproducibility of drawn random numbers:
set.seed(1234)
mcs_distances <- mcs_mileage(
  x = mcs_tbl,
  distribution = "lognormal"
)

# Example 2 - MCS for distances with exponential annual mileage distribution:
mcs_distances_2 <- mcs_mileage(
  x = mcs_tbl,
  distribution = "exponential"
)

# Example 3 - MCS for distances with downstream probability estimation:
## Apply 'estimate_cdf()' to *$data:
prob_estimation <- estimate_cdf(
  x = mcs_distances$data,
  methods = "kaplan"
)

## Apply 'plot_prob()':
plot_prob_estimation <- plot_prob(prob_estimation)

}
\seealso{
\link{dist_mileage} for the determination of a parametric annual mileage
distribution and \link{estimate_cdf} for the estimation of failure probabilities.
}
