% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture_identification.R
\name{mixmod_em.default}
\alias{mixmod_em.default}
\title{Weibull Mixture Model Estimation using EM-Algorithm}
\usage{
\method{mixmod_em}{default}(
  x,
  status,
  distribution = "weibull",
  conf_level = 0.95,
  k = 2,
  method = "EM",
  n_iter = 100L,
  conv_limit = 1e-06,
  diff_loglik = 0.01,
  ...
)
}
\arguments{
\item{x}{A numeric vector which consists of lifetime data. Lifetime data
could be every characteristic influencing the reliability of a product, e.g.
operating time (days/months in service), mileage (km, miles), load cycles.}

\item{status}{A vector of binary data (0 or 1) indicating whether a unit is a
right censored observation (= 0) or a failure (= 1).}

\item{distribution}{\code{"weibull"} until further distributions are implemented.}

\item{conf_level}{Confidence level for the intervals of the Weibull parameters
of every component \code{k}.}

\item{k}{Number of mixture components.}

\item{method}{\code{"EM"} until other methods are implemented.}

\item{n_iter}{Integer defining the maximum number of iterations.}

\item{conv_limit}{Numeric value defining the convergence limit.}

\item{diff_loglik}{Numeric value defining the maximum difference between
log-likelihood values, which seems permissible.}

\item{...}{Further arguments passed to or from other methods. Currently not used.}
}
\value{
A list with classes \code{wt_model} and \code{wt_mixmod_em}. The length of the
list depends on the number of specified subgroups \code{k}. The first \code{k} lists
contain information provided by \link{ml_estimation}. The values of \code{logL}, \code{aic}
and \code{bic} are the results of a weighted log-likelihood, where the weights are
the posterior probabilities determined by the algorithm. The last list summarizes
further results of the EM algorithm and is therefore called \code{em_results}. It
contains the following elements:
\itemize{
\item \code{a_priori} : A vector with estimated prior probabilities.
\item \code{a_posteriori} : A matrix with estimated posterior probabilities.
\item \code{groups} : Numeric vector specifying the group membership of every observation.
\item \code{logL} : The value of the complete log-likelihood.
\item \code{aic} : Akaike Information Criterion.
\item \code{bic} : Bayesian Information Criterion.
}
}
\description{
This method applies the expectation-maximization (EM) algorithm to estimate the
parameters of a univariate Weibull mixture model. See 'Details'.
}
\details{
The EM algorithm is an iterative algorithm for which starting values must be
defined. Starting values can be provided for the unknown parameter vector as
well as for the posterior probabilities. This implementation employs initial
values for the posterior probabilities. These are assigned randomly
by using the Dirichlet distribution, the conjugate prior of a multinomial
distribution (see Mr. Gelissen's blog post listed under \emph{references}).

\strong{M-Step} : On the basis of the initial posterior probabilities, the
parameter vector is estimated with \emph{Newton-Raphson}.

\strong{E-Step} : The actual estimated parameter vector is used to perform an
update of the posterior probabilities.

This procedure is repeated until the complete log-likelihood has converged.
}
\examples{
# Vectors:
hours <- voltage$hours
status <- voltage$status

# Example 1 - EM algorithm with k = 2:
mix_mod_em <- mixmod_em(
  x = hours,
  status = status,
  distribution = "weibull",
  conf_level = 0.95,
  k = 2,
  n_iter = 150
)

#' # Example 2 - Maximum likelihood is applied when k = 1:
mix_mod_em_2 <- mixmod_em(
  x = hours,
  status = status,
  distribution = "weibull",
  conf_level = 0.95,
  k = 1,
  method = "EM",
  n_iter = 150
)

}
\references{
\itemize{
\item Doganaksoy, N.; Hahn, G.; Meeker, W. Q., Reliability Analysis by Failure Mode,
Quality Progress, 35(6), 47-52, 2002
}
}
\seealso{
\link{mixmod_em}
}
