% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{autoplot.kde}
\alias{autoplot.kde}
\title{Produce ggplot of densities in 1 or 2 dimensions}
\usage{
\method{autoplot}{kde}(
  object,
  prob = seq(9)/10,
  fill = FALSE,
  show_hdr = FALSE,
  show_points = FALSE,
  show_mode = FALSE,
  show_lookout = FALSE,
  color = "#00659e",
  palette = hdr_palette,
  alpha = ifelse(fill, 1, min(1, 1000/NROW(object$x))),
  ...
)
}
\arguments{
\item{object}{Probability density function as estimated by \code{ks::kde()}.}

\item{prob}{Probability of the HDR contours to be drawn (for a bivariate plot only).}

\item{fill}{If \code{TRUE}, and the density is bivariate, the bivariate contours
are shown as filled regions rather than lines.}

\item{show_hdr}{If \code{TRUE}, and the density is univariate, then the HDR regions
specified by \code{prob} are shown as a ribbon below the density.}

\item{show_points}{If \code{TRUE}, then individual points are plotted.}

\item{show_mode}{If \code{TRUE}, then the mode of the distribution is shown.}

\item{show_lookout}{If \code{TRUE}, then the observations with lookout probabilities less than 0.05 are shown in red.}

\item{color}{Color used for mode and HDR contours. If \code{palette = hdr_palette},
it is also used as the basis for HDR regions.}

\item{palette}{Color palette function to use for HDR filled regions
(if \code{fill} is \code{TRUE} or \code{show_hdr} is \code{TRUE}).}

\item{alpha}{Transparency of points. When \code{fill} is \code{FALSE}, defaults to
min(1, 1000/n), where n is the number of observations. Otherwise, set to 1.}

\item{...}{Additional arguments are currently ignored.}
}
\value{
A ggplot object.
}
\description{
Produce ggplot of densities in 1 or 2 dimensions
}
\details{
This function produces a ggplot of the density estimate produced by \code{ks::kde()}.
For univariate densities, it produces a line plot of the density function, with
an optional ribbon showing some highest density regions (HDRs) and/or the observations.
For bivariate densities, it produces a contour plot of the density function, with
the observations optionally shown as points.
The mode can also be drawn as a point with the HDRs.
For bivariate densities, the combination of \code{fill = TRUE}, \code{show_points = TRUE},
\code{show_mode = TRUE}, and \code{prob = c(0.5, 0.99)} is equivalent to an HDR boxplot.
For univariate densities,  the combination of \code{show_hdr = TRUE}, \code{show_points = TRUE},
\code{show_mode = TRUE}, and \code{prob = c(0.5, 0.99)} is equivalent to an HDR boxplot.
}
\examples{
# Univariate density
c(rnorm(500), rnorm(500, 4, 1.5)) |>
  kde() |>
  autoplot(show_hdr = TRUE, prob= c(0.5, 0.95), color = "#c14b14")
ymat <- tibble(y1 = rnorm(5000), y2 = y1 + rnorm(5000))
ymat |>
  kde(H = kde_bandwidth(ymat)) |>
  autoplot(show_points = TRUE, alpha = 0.1, fill = TRUE)
}
\author{
Rob J Hyndman
}
