% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mab_assign.R
\name{assign_treatments}
\alias{assign_treatments}
\title{Adaptively Assign Treatments in a Period}
\usage{
assign_treatments(
  current_data,
  probs,
  blocking = NULL,
  conditions,
  condition_col,
  random_assign_prop
)
}
\arguments{
\item{current_data}{A tibble/data.table with only observations from the current sampling period.}

\item{probs}{Named numeric Vector; probability of assignment for each treatment condition.}

\item{blocking}{Logical; whether or not to use treatment blocking. Treatment blocking is used to ensure an even-enough
distribution of treatment conditions across blocks. For example, blocking by gender would mean the randomized assignment should
split treatments evenly not just throughout the sample (so for 4 arms, 25-25-25-25), but also within each block, so 25\% of men
would receive each treatment and 25\% of women the same.}

\item{condition_col}{Column in \code{data}; original treatment condition for each observation.}

\item{random_assign_prop}{A numeric value ranging from 0 to 1; proportion of each wave to be assigned new treatments randomly,
1 - \code{random_assign_prop} is the proportion assigned through the bandit procedure. For example if this is set to 0.1, then
for each wave 10\% of the observations will be randomly assigned to a new treatment, while the remaining 90\% will be assigned according
to UCB1 or Thompson result. It is not recommended to use this in conjunction with \code{control_augment}. If batch sizes are small,
and the number of rows is calculate to be less than 1, and probability sampling approach is used where each row in the batch
will have a \code{random_assign_prop} probability of being selected for random assignment. Otherwise the number is rounded to
a whole number, and that many rows are selected for random assignment.}
}
\value{
Updated tibble/data.table with the new treatment conditions for each observation, and whether imputation is required.
If this treatment is different then from under the original experiment, the 'impute_req' is 1, and else is 0 for the observation.
}
\description{
Assigns new treatments for an assignment wave based on the assignment probabilities provided from
\code{\link[=get_bandit]{get_bandit()}}, and the proportion of randomly assigned observations specified in \code{random_assign_prop}.
Assignments are made randomly with the given probabilities using \code{\link[randomizr:block_ra]{randomizr::block_ra()}} or
\code{\link[randomizr:complete_ra]{randomizr::complete_ra()}}.
}
\details{
The number of rows which are randomly assigned in each period is \code{random_assign_prop} multiplied by
the number of rows in the period. If this number is less than 1, then Bernoulli draws are made for each row
with probability \code{random_assign_prob} to determine if that row will be assigned randomly. Else, the number of random
rows is rounded to the nearest whole number, and then that many rows are selected to be assigned through
complete random assignment. The row selections are also random.
}
\seealso{
\itemize{
\item \code{\link[randomizr:block_ra]{randomizr::block_ra()}}
\item \code{\link[randomizr:complete_ra]{randomizr::complete_ra()}}
}
}
\keyword{internal}
