% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define.R
\name{define_characteristics}
\alias{define_characteristics}
\alias{define_characteristics.when}
\title{Define dimension characteristics}
\usage{
define_characteristics(
  td,
  name,
  surrogate_key,
  type,
  locale,
  week_starts_monday
)

\method{define_characteristics}{when}(
  td,
  name = NULL,
  surrogate_key = NULL,
  type = NULL,
  locale = NULL,
  week_starts_monday = NULL
)
}
\arguments{
\item{td}{A \code{when} object.}

\item{name}{A string, table name.}

\item{surrogate_key}{A boolean, include a surrogate key in the dimension table.}

\item{type}{A string, type of calendar (NULL, 'iso', 'epi' or 'time').}

\item{locale}{A locale, to use for day and month names.}

\item{week_starts_monday}{A boolean.}
}
\value{
A \code{when} object.
}
\description{
With this function we can define the characteristics of the dimension that do
not depend on the levels it includes, such as the name, type, location or the
day the week begins. It also allows us to define whether the table includes a
surrogate key.
}
\details{
The \code{week_starts_monday} parameter only affects the numbering of days, not weeks.

The week number associated with each date depends on the type of date dimension
selected: standard ('date'), ISO 8601 ('iso') or epidemiological ('epi').

The standard week numbers blocks of 7 days beginning on January 1. The last week
of the year can be less than 7 days long.

The ISO 8601 week numbers blocks of 7 days from Monday to Sunday. The first and
last week of the year can contain days from the previous or next year.

The epidemiological week is like ISO 8601 only that it considers that the week
begins on Sunday.
}
\examples{

td <- when() |>
  define_characteristics(name = 'time', type = 'time')

}
\seealso{
Other dimension definition: 
\code{\link{define_instances}()},
\code{\link{get_attribute_definition_function}()},
\code{\link{get_day_part}()},
\code{\link{get_week_date_range}()},
\code{\link{select_date_levels}()},
\code{\link{select_day_level}()},
\code{\link{select_month_level}()},
\code{\link{select_quarter_level}()},
\code{\link{select_semester_level}()},
\code{\link{select_time_level}()},
\code{\link{select_week_level}()},
\code{\link{select_year_level}()},
\code{\link{set_attribute_definition_function}()},
\code{\link{set_day_part}()},
\code{\link{when}()}
}
\concept{dimension definition}
