% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrape_faostat.R
\name{get_faostat_data}
\alias{get_faostat_data}
\title{Scrapes activity_data from FAOSTAT and slightly post-processes it}
\usage{
get_faostat_data(activity_data, ...)
}
\arguments{
\item{activity_data}{activity data required from FAOSTAT; needs
to be one of \code{c('livestock','crop_area','crop_yield','crop_production')}.}

\item{...}{can be whichever column name from \code{get_faostat_bulk},
particularly \code{year}, \code{area} or \code{ISO3_CODE}.}
}
\value{
\code{data.frame} of FAOSTAT for \code{activity_data}; default is for
all years and countries.
}
\description{
Important: Dynamically allows for the introduction of subsets as \code{"..."}.

Note: overhead by individually scraping FAOSTAT code QCL for crop data;
it's fine.
}
\examples{
\donttest{
get_faostat_data("livestock", year = 2010, area = "Portugal")
}
}
