% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/take_a_step.R
\name{take_a_step}
\alias{take_a_step}
\title{Track one movement}
\usage{
take_a_step(paths, roads, blocked = NULL)
}
\arguments{
\item{paths}{list of all possible paths already traveled}

\item{roads}{data.frame of non-directional edge pairs for either the road graph or the alley graph}

\item{blocked}{list of node pairs which cannot be traversed because a police officer blocks it (should not be used for special movement)}
}
\value{
list of all possible paths traveled by Jack
}
\description{
Track one step of unknown movement by Jack, either on roads or through alleyways
}
\details{
The non-directional edge pairs are available via \code{data(roads)} or \code{data(alley)}
This function does not account for the rule that Jack cannot travel through a road occupied by a police officer.
}
\examples{
possibilities = start_round(64)
possibilities = take_a_step(possibilities,roads)
possibilities = take_a_step(possibilities,roads,blocked=list(c(63,82),c(63,65)))
possibilities = take_a_step(possibilities,alley)
}
