% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj_winratio.R
\name{adj_winratio}
\alias{adj_winratio}
\title{Adjusted win ratio}
\usage{
adj_winratio(
  data,
  pid,
  baseline = NULL,
  outcome,
  covars = NULL,
  strata = NULL,
  arm,
  method = "small",
  sig.level = 0.05
)
}
\arguments{
\item{data}{a dataframe or matrix containing the analysis data. Must be in
wide format such that a participant's repeated responses are in a single row,
and each response is in a separate column.}

\item{pid}{a string indicating the name of the variable corresponding to
participant ID.}

\item{baseline}{a string indicating the name of the outcome measured at
baseline. If not specified, defaults to NULL, and no baseline adjustment is
employed.}

\item{outcome}{a vector of strings indicating the names of the outcomes
measured at each visit. Baseline, if specified, will be concatenated to this
vector within the code. The outcomes must have at least an ordinal
measurement scale with larger values being better than smaller values.
Thus, the outcome can be ordered categories or continuous measurements.}

\item{covars}{a vector of strings indicating the names of the covariates
(measured at baseline) used for adjustment. These covariates must be numeric
and can  be measured on a binary, categorical, ordered categorical, or
continuous scale. If not specified, defaults to NULL and no covariate
adjustment is employed.}

\item{strata}{a string indicating the name of the variable used for
stratification. If not specified, defaults to NULL and no stratification adjustment
is utilized.}

\item{arm}{a string indicating the name of the variable for treatment arm.
Treatment arm must be a positive integer such that the test treatment arm is
ALWAYS higher in value than the control arm.}

\item{method}{a string "small" or "large" used to denote the sample size
method employed. The small sample size method is recommended unless
within-stratum sample size is reasonably large (e.g., >= 50), number of
visits is small (e.g., <=6), and number of covariates is small (e.g., <=4).
Defaults to "small."}

\item{sig.level}{significance level (Type I error probability). Defaults to
0.05.}
}
\value{
A  dataframe containing:
\item{logWR}{natural log-transformed win ratio}
\item{SE_logWR}{standard error of log-transformed win ratio}
\item{Var_logWR}{sample variance of log-transformed win ratio}
\item{Chi_Square}{Pearson's Chi-squared test statistic corresponding to
logWR}
\item{p_value}{p-value corresponding to the Pearson's Chi-squared test}
\item{WR}{win ratio}
\item{LCL_WR}{lower bound of \eqn{(1-\alpha/2)\times 100\%} CI for WR}
\item{UCL_WR}{upper bound of \eqn{(1-\alpha/2)\times 100\%} CI for WR}
}
\description{
Randomization-based adjustment of the win ratio for baseline covariates and
strata.
}
\examples{

#--------------------------
# Respiratory example
#--------------------------

# Since IDs repeat at centers 1 and 2, create a new, unique ID
resp$UniqID<-resp$Center*100+resp$ID

# Convert treatment arm to binary
resp$Trt<-1*(resp$Treatment=="T")

# Indicator for male
resp$SexNum<-1*(resp$Sex=="M")

adj_winratio(data=resp,
            pid="UniqID",
            baseline="Baseline",
            outcome=c("Visit1","Visit2","Visit3","Visit4"),
            covars= c("SexNum","Age"),
            strata="Center",
            arm="Trt",
            method="small",
            sig.level=0.05)

#----------------------
# Dermatology example
#----------------------

#Generate indicators for stage 4 and 5
skin$Stage4 = (skin$STAGE == 4)*1
skin$Stage5 = (skin$STAGE == 5)*1

# Generate treatment center
skin$center<-ifelse(skin$INV==5,1,
  ifelse(skin$INV==6,2,
    ifelse(skin$INV==8,3,
      ifelse(skin$INV==9,4,
        ifelse(skin$INV==10,5,6)))))

# Generate treatment center that pools centers 3 and 4 due to small sample size
skin$center2 = skin$center
skin$center2<-ifelse(skin$center == 4, 3, skin$center)

# Generate participant IDs
skin$ID<-1:nrow(skin)

adj_winratio(data=skin,
            pid="ID",
            baseline=NULL,
            outcome=c("R1","R2","R3"),
            covars= c("Stage4","Stage5"),
            strata="center2",
            arm="TRT",
            method="small",
            sig.level=0.05)

}
