% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wodds.R
\name{wodds}
\alias{wodds}
\title{Calculate whisker odds}
\usage{
wodds(
  y,
  alpha = 0.05,
  include_tail_area = FALSE,
  include_outliers = FALSE,
  include_depth = FALSE
)
}
\arguments{
\item{y}{A vector of values}

\item{alpha}{the alpha level, such as 0.05 which is the compliment of the confidence interval, such as 0.95}

\item{include_tail_area}{a binary.
If true then include a column of tail area 2^(i)}

\item{include_outliers}{a binary.
If true include a column of outliers beyond the last wodd depth}

\item{include_depth}{a binary.
If true include a column indicating the depth of the letter value}
}
\value{
A dataframe of wodds
  \item{lower_value}{lower value}
  \item{wodd_name}{Name of wodd}
  \item{upper_value}{upper value}
}
\description{
makes whisker odds
}
\examples{
set.seed(42)
wodds(rnorm(1e4, 0, 1))
}
