% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{wb_country}
\alias{wb_country}
\title{World Bank country data}
\source{
\url{https://api.worldbank.org/v2/country}
}
\usage{
wb_country(country = NULL, lang = "en")
}
\arguments{
\item{country}{(\code{NULL} | \code{character()})\cr
Country to query. Default \code{NULL}. If \code{NULL}, all countries are returned.}

\item{lang}{(\code{character(1)})\cr
Language to query. Default \code{"en"}.}
}
\value{
A \code{data.frame()} with the available countries. The columns are:
\item{country_id}{The country ID.}
\item{country_code}{The country code.}
\item{country_name}{The country name.}
\item{region_id}{The region ID.}
\item{region_code}{The region code.}
\item{region_value}{The region value.}
\item{admin_region_id}{The admin region ID.}
\item{admin_region_code}{The admin region code.}
\item{admin_region_value}{The admin region value.}
\item{income_level_id}{The income level ID.}
\item{income_level_code}{The income level code.}
\item{income_level_value}{The income level value.}
\item{lending_type_id}{The lending type ID.}
\item{lending_type_code}{The lending type code.}
\item{lending_type_value}{The lending type value.}
\item{capital_city}{The capital city.}
\item{longitude}{The longitude.}
\item{latitude}{The latitude.}
}
\description{
List all countries supported by the World Bank API.
}
\examples{
\dontshow{if (httr2::is_online()) withAutoprint(\{ # examplesIf}
country <- wb_country()
head(country)
\dontshow{\}) # examplesIf}
}
\seealso{
Other indicators data: 
\code{\link{wb_income_level}()},
\code{\link{wb_indicator}()},
\code{\link{wb_language}()},
\code{\link{wb_lending_type}()},
\code{\link{wb_region}()},
\code{\link{wb_source}()},
\code{\link{wb_topic}()}
}
\concept{indicators data}
