% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull-related-recs.R
\name{pull_related_recs}
\alias{pull_related_recs}
\title{Pull related records}
\usage{
pull_related_recs(uts, num_recs, editions = c("SCI", "SSCI", "AHCI",
  "ISTP", "ISSHP", "BSCI", "BHCI", "IC", "CCR", "ESCI"),
  sid = auth(Sys.getenv("WOS_USERNAME"), Sys.getenv("WOS_PASSWORD")),
  ...)
}
\arguments{
\item{uts}{The documents whose related records you want to pull.}

\item{num_recs}{Number of related records to pull for each UT. This value
must be <= 100.}

\item{editions}{Web of Science editions to query. Possible values are listed
\href{http://ipscience-help.thomsonreuters.com/wosWebServicesLite/dbEditionsOptionsGroup/databaseEditionsWos.html}{here}.}

\item{sid}{Session identifier (SID). The default setting is to get a fresh
SID each time you query WoS via a call to \code{\link{auth}}. However,
you should try to reuse SIDs across queries so that you don't run into the
throttling limits placed on new sessions.}

\item{...}{Arguments passed along to \code{\link[httr]{POST}}.}
}
\value{
A data frame with the following columns:
 \describe{
   \item{ut}{The publications that you passed into \code{pull_related_recs}.
   If one of your publications doesn't have any related records, it won't
   appear here.}

   \item{related_rec}{The publication that is related to \code{ut}.}

   \item{rec_num}{The related record's ordering in the result set returned
   by the API. Records that share more citations with your UTs will have
   smaller \code{rec_num}s.}
 }
}
\description{
Pull the records that have at least one citation in common with a publication
of interest.
}
\examples{
\dontrun{

sid <- auth("your_username", password = "your_password")
uts <- c("WOS:000272877700013", "WOS:000272366800025")
out <- pull_related_recs(uts, 5, sid = sid)
}
}
