% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anlz_sumstats.R
\name{anlz_sumstats}
\alias{anlz_sumstats}
\title{Retrieve summary statistics for seasonal metrics and trend results}
\usage{
anlz_sumstats(
  mod,
  metfun = mean,
  doystr = 1,
  doyend = 364,
  yrstr = 2000,
  yrend = 2019,
  yromit = NULL,
  nsim = 10000,
  confint = 0.95,
  useave = FALSE,
  ...
)
}
\arguments{
\item{mod}{input model object as returned by \code{\link{anlz_gam}}}

\item{metfun}{function input for metric to calculate, e.g., \code{mean}, \code{var}, \code{max}, etc}

\item{doystr}{numeric indicating start Julian day for extracting averages}

\item{doyend}{numeric indicating ending Julian day for extracting averages}

\item{yrstr}{numeric for starting year for trend model, see details}

\item{yrend}{numeric for ending year for trend model, see details}

\item{yromit}{optional numeric vector for years to omit from the plot, see details}

\item{nsim}{numeric indicating number of random draws for simulating uncertainty}

\item{confint}{numeric from zero to one indicating confidence interval level for summarizing the mixed-effects meta-analysis model, see details}

\item{useave}{logical indicating if \code{anlz_avgseason} is used for the seasonal metric calculation, see details}

\item{...}{additional arguments passed to \code{metfun}, e.g., \code{na.rm = TRUE}}
}
\value{
A list object with named elements:

\itemize{
 \item \code{mixmet}: \code{\link[mixmeta]{mixmeta}} object of the fitted mixed-effects meta-analysis trend model
 \item \code{metseason}: tibble object of the fitted seasonal metrics as returned by \code{\link{anlz_metseason}} or \code{\link{anlz_avgseason}}
 \item \code{summary}: summary of the \code{mixmet} object
 \item \code{coeffs}: tibble object of the slope estimate coefficients from the \code{mixmet} model. An approximately linear slope estimate will be included as \code{slope.approx} if \code{trans = 'log10'} for the GAM used in \code{mod}.
}
}
\description{
Retrieve summary statistics for seasonal metrics and trend results
}
\details{
This function is primarily for convenience to return summary statistics of a fitted GAM from \code{\link{anlz_gam}}. 

Note that \code{confint} only applies to the \code{summary} and \code{coeffs} list outputs.  It does not apply to the \code{metseason} list element output that is default set to 95% confidence for the trend metric intervals.

Set \code{useave = T} to speed up calculations if \code{metfun = mean}.  This will use \code{\link{anlz_avgseason}} to estimate the seasonal summary metrics using a non-stochastic equation.
}
\examples{
library(dplyr)

# data to model
tomod <- rawdat \%>\%
  filter(station \%in\% 34) \%>\%
  filter(param \%in\% 'chl') \%>\% 
  filter(yr > 2015)

mod <- anlz_gam(tomod, trans = 'log10')

anlz_sumstats(mod, metfun = mean, doystr = 90, doyend = 180, yrstr = 2016, 
  yrend = 2019, nsim = 100)
}
\concept{analyze}
