% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonAmbiguousNum.R
\name{nonAmbiguousNum}
\alias{nonAmbiguousNum}
\title{Make numeric vector non-ambiguous (ie unique)}
\usage{
nonAmbiguousNum(
  x,
  uniqOnly = FALSE,
  asList = FALSE,
  nameMod = "amb_",
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{x}{(numeric) main input}

\item{uniqOnly}{(logical) if=TRUE return unique only, if =FALSE return unique and single representative of non-unique values (with '' added to name), selection of representative of repeated: first (of sorted) or middle if >2 instances}

\item{asList}{(logical) return list}

\item{nameMod}{(character) text to add in case on ambiguous values, default="amb_"}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
sorted non-ambigous numeric vector (or list if 'asList'=TRUE and 'uniqOnly'=FALSE)
}
\description{
Thios function transfomrmes a vector of (named) numeric values \code{x} into unique. 
Note: for non-numeric use the function \code{\link{firstOfRepeated}} - but 1000x slower !
Return sorted non-ambigous numeric vector (or list if 'asList'=TRUE and 'uniqOnly'=FASLSE)
}
\examples{
set.seed(2017); aa <- round(rnorm(100),2); names(aa) <- 1:length(aa)
str(nonAmbiguousNum(aa))
str(nonAmbiguousNum(aa,uniq=FALSE,asLi=TRUE))
}
\seealso{
\code{\link{firstOfRepeated}} for non-numeric use (much slower !!!), \code{\link[base]{duplicated}}
}
