% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_wsj.R
\name{label_wsj}
\alias{label_wsj}
\title{Label plots like the wall street journal
i.e. display the units only on the top tick of the graph}
\usage{
label_wsj(prefix = "$", suffix = "", rm.bottom = TRUE, accuracy = NA, ...)
}
\arguments{
\item{prefix}{character, the unit label to prefix on the max number of the y-axis}

\item{suffix}{character, the unit label to append on the max number of the y-axis}

\item{rm.bottom}{logical, remove the lowest number?}

\item{accuracy}{double, the precision for labels e.g. 1, 0.1, or 0.01}

\item{...}{args passed to scales::label_comma(...)}
}
\description{
Label plots like the wall street journal
i.e. display the units only on the top tick of the graph
}
\examples{
library(ggplot2)
`\%>\%` <- magrittr::`\%>\%`

plt <- economics_long \%>\%
  dplyr::filter(variable \%in\% c("psavert", "uempmed")) \%>\%
  ggplot(aes(date, value, color = variable)) +
  geom_line() +
  scale_y_continuous(
      labels = label_wsj(prefix = "$", suffix = " \%")
  ) +
  theme_wsj() +
  labs(
    title = "Some Economics Plot",
    caption = "Source: Top secret."
  )

}
