% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_tests.R
\name{multi_lag_test}
\alias{multi_lag_test}
\title{Multi-Lag Hypothesis Test}
\usage{
multi_lag_test(
  f_data,
  lag = 20,
  M = NULL,
  iid = FALSE,
  alpha = 0.05,
  suppress_raw_output = FALSE,
  suppress_print_output = FALSE
)
}
\arguments{
\item{f_data}{The functional data matrix with observed functions in the columns}

\item{lag}{Positive integer value. The lag to use to compute the multi-lag test statistic}

\item{M}{Positive integer value. Number of Monte-Carlo simulation for Welch-Satterthwaite approximation.}

\item{iid}{A Boolean value, FALSE by default. If given TRUE, the hypothesis test will use a strong-white
noise assumption (instead of a weak-white noise assumption).}

\item{alpha}{Numeric value between 0 and 1 specifying the significance level to be used in the specified
hypothesis test. The default value is 0.05. Note, the significance value is only ever used to compute the
1-alpha quantile of the limiting distribution of the specified test's test statistic.}

\item{suppress_raw_output}{Boolean value, FALSE by default. If TRUE, the function will not return the list
containing the p-value, quantile, and statistic.}

\item{suppress_print_output}{Boolean value, FALSE by default. If TRUE, the function will not print any
output to the console.}
}
\value{
If suppress_raw_output = FALSE, a list containing the test statistic, the 1-alpha quantile of the
limiting distribution, and the p-value computed from the specified hypothesis test. Also prints output
containing a short description of the test, the p-value, and additional information about the test if
suppress_print_output = FALSE.
}
\description{
`multi_lag_test` Computes the multi-lag hypothesis test over a range of user-specified lags.
}
\details{
The "multi-lag" portmanteau test is also based on the sample autocovariance function computed from the
functional data. This test assesses the cumulative significance of lagged autocovariance operators, up to a
user-selected maximum lag K. More specifically, it tests the null hypothesis that the first K lag-h autocovariance
operators (h going from 1 to K) is equal to 0. This test is designed for stationary functional time-series, and
is valid under conditional heteroscedasticity conditions.
}
\examples{
b <- brown_motion(150, 50)
multi_lag_test(b, lag = 5)
multi_lag_test(b, lag = 10, M = 50)

}
\references{
[1] Kokoszka P., & Rice G., & Shang H.L. (2017). Inference for the autocovariance of a functional time series
under conditional heteroscedasticity. Journal of Multivariate Analysis, 162, 32-50.
}
