% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_TmaxTmin.R
\name{generate_TmaxTmin}
\alias{generate_TmaxTmin}
\title{Generate maximum and minimum daily temperature from daily average temperature}
\usage{
generate_TmaxTmin(df.train, df.sim)
}
\arguments{
\item{df.train}{A dataframe containing the daily training data used to develop the relationship
between average and maximum temperature. At a minimum should contain variables named `tmax`, `temp`, and `month`
which represent maximum temperature, average temperature, and numeric month in which the daily observation exists, respectively.}

\item{df.sim}{A dataframe containing the daily simulation results from the `wx` function in long format. At a minimum should contain
variables named `sim_temp` and `month` which respectively represent the simulated daily average temperature from `wx`
and the numeric month in which each data point resides.}
}
\value{
Returns a list containing results and metadata from the multisite shuffling in 'long' format for easy analysis and visualization.
\itemize{
  \item df.sim - Dataframe containing simulated maximum and minimum temperature generated from daily average temperature.
  \item qmap.monthly - List of dataframes containing fitted quantile mapping models for each calendar month.
}
}
\description{
Estimate maximum and minimum temperature from `wx` simulation results of daily average temperature. This function uses quantile mapping
to develop a relationship between daily average temperature and daily maximum temperature. Average and maximum temperature can be contained in your training
data for example. Then, the relationship between average and maximum temperature is applied to the simulated daily average temperature output by `wx` to estimate
a simulated daily maximum temperature. Daily minimum temperature is then estimated using the standard equation Tavg = 0.5(Tmax + Tmin).
\cr\cr
Quantile mapping is trained and applied separately by calendar month.
The quantile mapping function comes from the `qmap` R package, specifically using empirical quantiles.
\cr\cr
 You will likely need to post-process the `wx` function output in order
 to process each simulation trace since the `wx` output is in wide format by trace
  and this function is best applied in long format. Code examples for processing both the training data and simulated data
  to put into suitable  format for the `generate_TmaxTmin` function are available here:\cr\cr
  https://github.com/dwoodson-usbr/wxgenR/tree/master/vignettes
}
\examples{
\donttest{
# Example with toy data
df.train = data.frame(
  temp = runif(10, 50, 70),
  tmax = runif(10, 60, 80),
  month = rep(1:2, each = 5)
)

df.sim = data.frame(
  sim_temp = runif(10, 50, 70),
  month = rep(1:2, each = 5)
)

result = generate_TmaxTmin(df.train, df.sim)
head(result$df.sim)
}

}
\references{
Gudmundsson L (2025). qmap: Statistical transformations for post-processing climate model output. R package version 1.0-6.

Gudmundsson L, Bremnes JB, Haugen JE, Engen-Skaugen T (2012). “Technical Note: Downscaling RCM precipitation to the station scale using statistical transformations - a comparison of methods.” Hydrology and Earth System Sciences, 16(9), 3383–3390. doi:10.5194/hess-16-3383-2012.
}
