% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNFhelpers.R
\name{directRecursion}
\alias{directRecursion}
\title{Which production rules contain a direct recursion?}
\usage{
directRecursion(G)
}
\arguments{
\item{G}{A compiled context-free grammar.}
}
\value{
Vector of booleans.
}
\description{
Which production rules contain a direct recursion?
}
\details{
Direct recursion means the nonterminal on the LHS 
         is also a symbol on RHS of production rule.
}
\examples{
g<-compileBNF(booleanGrammar())
directRecursion(g)

}
\seealso{
Other Compilation of short production table: 
\code{\link{allTerminal}()},
\code{\link{cL}()},
\code{\link{expandGrid}()},
\code{\link{expandRules}()},
\code{\link{findNextRuleForExpansion}()},
\code{\link{finiteRulesOfG}()},
\code{\link{nonTerminalsOfG}()},
\code{\link{smallestRules}()}
}
\concept{Compilation of short production table}
