% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivationTrees.R
\name{rndsub}
\alias{rndsub}
\title{Transforms a non-terminal symbol into a random 1-level derivation tree.}
\usage{
rndsub(sym, PT)
}
\arguments{
\item{sym}{Non-terminal symbol.}

\item{PT}{Production table.}
}
\value{
Derivation tree with 1-level.
}
\description{
\code{rndsub()} expands a non-terminal by a random derivation
             and returns a 1-level derivation tree.
}
\examples{
g<-compileBNF(booleanGrammar())
rndsub(g$Start, g$PT)

}
\seealso{
Other Generate Derivation Tree: 
\code{\link{generateCDT}()},
\code{\link{generateDerivationTree}()},
\code{\link{randomDerivationTree}()},
\code{\link{rndsubk}()},
\code{\link{substituteSymbol}()}
}
\concept{Generate Derivation Tree}
