% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaDfMutate.R
\name{xegaDfMutationFactory}
\alias{xegaDfMutationFactory}
\title{Configure the mutation function of a genetic algorithm.}
\usage{
xegaDfMutationFactory(method = "MutateGene")
}
\arguments{
\item{method}{A string specifying the mutation function.}
}
\value{
A mutation function for genes.
}
\description{
\code{xegaDfMutationFactory()} implements the selection
             of one of the mutation functions in this
             package by specifying a text string.
             The selection fails ungracefully (produces
             a runtime error), if the label does not match.
             The functions are specified locally.

             Current support:

             \enumerate{
             \item "MutateGene" returns \code{xegaDfMutateGeneDE()}.
                   To provide a working default for more than 
                   one gene representation.
             \item "MutateGeneDE" returns \code{xegaDfMutateGeneDE()}.
             }
}
\examples{
Mutate<-xegaDfMutationFactory("MutateGene")
gene1<-xegaDfInitGene(lFxegaDfGene)
gene2<-xegaDfInitGene(lFxegaDfGene)
gene3<-xegaDfInitGene(lFxegaDfGene)
Mutate(gene1, gene2, gene3, lFxegaDfGene)
}
\seealso{
Other Configuration: 
\code{\link{lFxegaDfGene}},
\code{\link{xegaDfCrossoverFactory}()},
\code{\link{xegaDfGeneMapFactory}()},
\code{\link{xegaDfReplicationFactory}()},
\code{\link{xegaDfScaleFactorFactory}()}
}
\concept{Configuration}
