% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terminate.R
\name{terminateAbsoluteError}
\alias{terminateAbsoluteError}
\title{Terminates, if the absolute deviation from the global optimum is small.}
\usage{
terminateAbsoluteError(solution, lF)
}
\arguments{
\item{solution}{A named list with at least the following elements:
$name, $fitness, $value, $numberOfSolutions, 
$genotype, $phenotype, $phenotypeValue.}

\item{lF}{Local function configuration. It must contain
\itemize{
\item \code{lF$penv$globalOptimum()} which returns 
      the global optimum. 
\item \code{lF$TerminationEps()} which specifies the 
      the maximal allowed deviation of the current 
      best solution from the global optimum.
}}
}
\value{
Boolean.
}
\description{
\code{terminateAbsoluteError()} 
returns \code{TRUE} if the value of the current solution 
is in the interval from (globalOptimum - eps) to 
(globalOptimum + eps).
}
\details{
Useful for benchmark functions with known global optima.
}
\examples{
    parm<-function(x){function() {return(x)}}
    olst<-list(); olst$value<-10
    penv<-list(); penv$globalOptimum<-parm(olst)
    lF<-list(); lF$penv<-penv; lF$TerminationEps<-parm(1.2);lF$Max<-parm(1.0)
    solution<-list(); solution$genotype<-list(); solution$genotype$fit<-8.0
    terminateAbsoluteError(solution, lF)
    solution<-list(); solution$genotype<-list(); solution$genotype$fit<-8.9
    terminateAbsoluteError(solution, lF)
}
\seealso{
Other Termination Condition: 
\code{\link{terminateGEQ}()},
\code{\link{terminateLEQ}()},
\code{\link{terminatePAC}()},
\code{\link{terminateRelativeError}()},
\code{\link{terminateRelativeErrorZero}()},
\code{\link{terminatedFalse}()}
}
\concept{Termination Condition}
