% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling.R
\name{ScalingFactory}
\alias{ScalingFactory}
\title{Scaling Factory}
\usage{
ScalingFactory(method = "NoScaling")
}
\arguments{
\item{method}{A scaling method. Available methods are:
\itemize{ 
 \item "NoScaling": Identity (Default).       
 \item "ConstantScaling": \code{fit^k} with constant exponent.
       Function \code{ConstantScaling()}.
 \item "ThresholdScaling": 
 \itemize{
 \item 
 If the dispersion ratio is larger than \code{1+threshold}, 
 use a constant scaling exponent with a value below 1 
 (decrease of selection pressure).
       Function \code{ThresholdScaling()}.
 \item If the dispersion ratio is lower than \code{1-threshold}, 
 use a constant scaling exponent with a value above 1
 (increase of selection pressure).
 \item Else use a scaling exponent of 1. This means no scaling.
 }
 \item "ContinuousScaling": Use weighted dispersion ratio 
 as scaling exponent.
 Function \code{ContinuousScaling()}.
 }}
}
\value{
A scaling function.
}
\description{
Scaling Factory
}
\examples{
fit<-sample(10, 20, replace=TRUE)
lF<-list()
lF$ScalingExp<-parm(2)
Scale<-ScalingFactory()
fit
Scale(fit, lF)
Scale<-ScalingFactory("ConstantScaling")
Scale(fit, lF)
}
\seealso{
Other Configuration: 
\code{\link{DispersionMeasureFactory}()},
\code{\link{EvalGeneFactory}()},
\code{\link{SelectGeneFactory}()}
}
\concept{Configuration}
