% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml_convert.r
\name{xml_to_list}
\alias{xml_to_list}
\title{Converting XML documents to lists}
\usage{
xml_to_list(
  xml,
  cleanup = TRUE,
  convert.types = TRUE,
  dec = ".",
  thsd = ",",
  num.replace = "",
  datetime.formats = NULL
)
}
\arguments{
\item{xml}{XML document to be converted. Can be read in from a file using
\code{xml2}'s \code{read_xml()} function.}

\item{cleanup}{If \code{TRUE} (default) empty XML nodes (with no sub-nodes or
values) will not appear in the list.}

\item{convert.types}{If \code{TRUE} (default) \code{xml_to_list()} will try
to infer the data type of value elements in the XML. If \code{FALSE}, all
value elements in the resulting list will be of type \code{character}.}

\item{dec}{Decimal separator used in numbers.}

\item{thsd}{Thousands separator used in numbers.}

\item{num.replace}{An optional string that will be removed before
\code{xml_to_list()} tries to convert values to numbers. Can be used, for
example, to remove currency symbols or other measurement units from values
that are actually numerical.}

\item{datetime.formats}{A vector of date and/or time formats that will be
used to recognize the respective datatypes. Formats will need to be written
in the general notation used by \code{\link[base:strftime]{strftime()}} and
other standard R functions.}
}
\value{
A \code{list} object representing the XML document.
}
\description{
Converts XML documents to lists. Uses the
  \code{\link[xml2:as_list]{as_list()}} function from the
  \code{xml2} package but improves its output. As an effect, numbers, dates
  and times are converted correctly, unnecessary nested sub-lists with only
  element are avoided, and empty XML nodes can be removed altogether. This
  makes the resulting list look cleaner and better structured.
}
\examples{
xml <- xml2::read_xml(system.file("customers.xml", package="xmlconvert"))
xml.list <- xml_to_list(xml, num.replace="USD", datetime.formats = "\%Y-\%m-\%d")#'

}
