% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_frag.R
\name{data_frag}
\alias{data_frag}
\title{Create an xml_fragment from a data.frame}
\usage{
data_frag(df, row_tags = "row", .attr = NULL)
}
\arguments{
\item{df}{data frame that will be stored as set of xml elements}

\item{row_tags}{\code{character} the tag name that is used for each row. Note that
this can be a single value or a vector of length equal to the number of rows in the data.frame.}

\item{.attr}{optional \code{data.frame} with xml row attributes}
}
\value{
\code{\link[=xml_fragment]{xml_fragment()}} object
}
\description{
Create a \code{\link[=xml_fragment]{xml_fragment()}} from a data.frame, in which each row is a set of xml elements (columns).
}
\examples{
persons <- data.frame(
  name = c("John Doe", "Jane Doe"),
  age = c(30, 25),
  stringsAsFactors = FALSE
)

df <- data_frag(persons, row_tag = "person")
print(df)

# setting ids on rows
persons <- data.frame(
  name = c("John Doe", "Jane Doe"),
  age = c(30, 25),
  id = c("p1", "p2"),
  stringsAsFactors = FALSE
)

df <- data_frag(
  persons[1:2],
  row_tag = "person",
  .attr = persons[3]
)

print(df)

# turning it into a document
doc <- xml_doc("study", id = "1") / frag(
  source = "homeless db",
  data = df
)

cat(as.character(doc))
}
\seealso{
Other xml_fragment: 
\code{\link{add_child_fragment}()},
\code{\link{as.character.xml_fragment}()},
\code{\link{as_frag}()},
\code{\link{as_xml_nodeset}()},
\code{\link{frag}()},
\code{\link{xml_fragment}()}
}
\concept{xml_fragment}
