% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag.R
\name{tag}
\alias{tag}
\title{Create a tag fragment}
\usage{
tag(tag, text = NULL, ..., .attr = list(...))
}
\arguments{
\item{tag}{character, the name of the tag}

\item{text}{character, the text to include in the tag}

\item{...}{additional attributes to add to the tag}

\item{.attr}{a list of additional attributes to add to the tag, overrides the \code{...} argument}
}
\value{
an xml_fragment with the new tag added
}
\description{
Create a tag fragment with optional text and attributes
}
\examples{

tag("greeting", "hi", id = "hi")

tag("person", id = "1") / (tag("name", "John Doe") + tag("age", 35))

xml_fragment(person = frag(
  .attr = c(id = 1),
  name = "John Doe",
  age = 30
))   / tag("address", "Unknown")


a <- tag("person", id = 1) /
  xml_fragment(
    name ="John Doe",
    age = 30,
    address = frag(
      street = "123 Main St",
      city = "Springfield"
    )
  )

cat(as.character(a))
}
