% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters_tskrrTune.R
\name{is_tuned}
\alias{is_tuned}
\alias{get_grid}
\alias{get_loss_values}
\alias{has_onedim}
\title{Getters for tskrrTune objects}
\usage{
is_tuned(x)

get_grid(x)

get_loss_values(x)

has_onedim(x)
}
\arguments{
\item{x}{a \code{\link[xnet:tskrrTune-class]{tskrrTune}} object or an
object inheriting from \code{tskrrTune}.}
}
\value{
For \code{is_tuned}: a logical value indicating whether the
model is tuned.

For \code{get_grid} a list with the elements \code{k} and
possibly \code{g}, each containing the different lambdas tried in
the tuning for the row and column kernel matrices respectively.

For \code{get_loss_values} a matrix with the calculated
loss values. Note that each row represents the result for one
lambda value related to the row kernel matrix K. For heterogeneous
models, every column represents the result for one lambda related
to the column kernel matrix G.

for \code{is_onedim} a single logical value telling whether the
grid search in the object was onedimensional.
}
\description{
The functions described here are convenience functions to get
information out of a \code{\link[xnet:tskrrTune-class]{tskrrTune}}
object.
}
\examples{

data(drugtarget)

mod <- tskrr(drugTargetInteraction, targetSim, drugSim)
tuned <- tune(mod, ngrid = 10)

is_tuned(mod)
is_tuned(tuned)

# Basic visualization of the grid.

gridvals <- get_grid(tuned)
z <- get_loss_values(tuned)

\dontrun{
image(gridvals$k,gridvals$g,log(z), log = 'xy',
xlab = "lambda k", ylab = "lambda g")
}

}
