% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module2_estimate_gpcm.R
\name{estimate_gpcm}
\alias{estimate_gpcm}
\alias{model_gpcm_eap_scoring}
\alias{model_gpcm_map_scoring}
\alias{model_gpcm_dv_Pt}
\alias{model_gpcm_dv_Pa}
\alias{model_gpcm_dv_Pb}
\alias{model_gpcm_dv_Pd}
\alias{model_gpcm_dv_jmle}
\alias{model_gpcm_estimate_jmle}
\alias{model_gpcm_dv_mmle}
\alias{model_gpcm_estimate_mmle}
\alias{model_gpcm_fitplot}
\title{Estimate Generalizaed Partial Credit Model}
\usage{
model_gpcm_eap_scoring(u, a, b, d, D = 1.702, prior = c(0, 1),
  bound = c(-3, 3))

model_gpcm_map_scoring(u, a, b, d, D = 1.702, prior = NULL,
  bound = c(-3, 3), nr_iter = 30, nr_conv = 0.001)

model_gpcm_dv_Pt(t, a, b, d, D)

model_gpcm_dv_Pa(t, a, b, d, D)

model_gpcm_dv_Pb(t, a, b, d, D)

model_gpcm_dv_Pd(t, a, b, d, D)

model_gpcm_dv_jmle(ix, dvp)

model_gpcm_estimate_jmle(u, t = NA, a = NA, b = NA, d = NA,
  D = 1.702, iter = 100, nr_iter = 10, conv = 1, nr_conv = 0.001,
  scale = c(0, 1), bounds_t = c(-4, 4), bounds_a = c(0.01, 2),
  bounds_b = c(-4, 4), bounds_d = c(-4, 4), priors = list(t = c(0,
  1), a = c(-0.1, 0.2), b = c(0, 1), d = c(0, 1)), decay = 1,
  debug = FALSE, true_params = NULL)

model_gpcm_dv_mmle(u_ix, quad, pdv)

model_gpcm_estimate_mmle(u, t = NA, a = NA, b = NA, d = NA,
  D = 1.702, iter = 100, nr_iter = 10, conv = 1, nr_conv = 0.001,
  bounds_t = c(-4, 4), bounds_a = c(0.01, 2), bounds_b = c(-4, 4),
  bounds_d = c(-4, 4), priors = list(t = c(0, 1), a = c(-0.1, 0.2), b =
  c(0, 1), d = c(0, 1)), decay = 1, quad_degree = "11",
  scoring = c("eap", "map"), debug = FALSE, true_params = NULL)

model_gpcm_fitplot(u, t, a, b, d, D = 1.702, insert_d0 = NULL,
  index = NULL, intervals = seq(-3, 3, 0.5), show_points = TRUE)
}
\arguments{
\item{u}{the observed response matrix, 2d matrix}

\item{a}{discrimination parameters, 1d vector (fixed value) or NA (freely estimate)}

\item{b}{difficulty parameters, 1d vector (fixed value) or NA (freely estimate)}

\item{d}{category parameters, 2d matrix (fixed value) or NA (freely estimate)}

\item{D}{the scaling constant, 1.702 by default}

\item{prior}{the prior distribution}

\item{nr_iter}{the maximum iterations of newton-raphson}

\item{nr_conv}{the convegence criterion for newton-raphson}

\item{t}{ability parameters, 1d vector (fixed value) or NA (freely estimate)}

\item{ix}{the 3d indices}

\item{dvp}{the derivatives of P}

\item{iter}{the maximum iterations}

\item{conv}{the convergence criterion of the -2 log-likelihood}

\item{scale}{the scale of theta parameters}

\item{bounds_t}{bounds of ability parameters}

\item{bounds_a}{bounds of discrimination parameters}

\item{bounds_b}{bounds of location parameters}

\item{bounds_d}{bounds of category parameters}

\item{priors}{a list of prior distributions}

\item{decay}{decay rate}

\item{debug}{TRUE to print debuggin information}

\item{true_params}{a list of true parameters for evaluating the estimation accuracy}

\item{quad_degree}{the number of quadrature points}

\item{scoring}{the scoring method: 'eap' or 'map'}

\item{insert_d0}{insert an initial category value}

\item{index}{the indices of items being plotted}

\item{intervals}{intervals on the x-axis}

\item{show_points}{TRUE to show points}
}
\description{
Estimate the GPCM using the maximum likelihood estimation

\code{model_gpcm_eap_scoring} scores response vectors using the EAP method

\code{model_gpcm_map_scoring} scores response vectors using maximum a posteriori

\code{model_gpcm_estimate_jmle} estimates the parameters using the 
joint maximum likelihood estimation (JMLE) method

\code{model_gpcm_estimate_mmle} estimates the parameters using the 
marginal maximum likelihood estimation (MMLE) method
}
\examples{
with(model_gpcm_gendata(10, 40, 3), cbind(true=t, est=model_gpcm_eap_scoring(u, a, b, d)$t))
with(model_gpcm_gendata(10, 40, 3), cbind(true=t, est=model_gpcm_map_scoring(u, a, b, d)$t))
\dontrun{
# generate data
x <- model_gpcm_gendata(1000, 40, 3)
# free calibration
y <- model_gpcm_estimate_jmle(x$u, true_params=x)
# no priors
y <- model_gpcm_estimate_jmle(x$u, priors=NULL, true_params=x)
}
\dontrun{
# generate data
x <- model_gpcm_gendata(1000, 40, 3)
# free estimation
y <- model_gpcm_estimate_mmle(x$u, true_params=x)
# no priors
y <- model_gpcm_estimate_mmle(x$u, priors=NULL, true_params=x)
}
with(model_gpcm_gendata(1000, 20, 3), model_gpcm_fitplot(u, t, a, b, d, index=c(1, 3, 5)))
}
\keyword{internal}
