% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grnn.partial.R
\name{grnn.partial}
\alias{grnn.partial}
\title{Derive the partial effect of a predictor used in a GRNN}
\usage{
grnn.partial(net, i, plot = TRUE)
}
\arguments{
\item{net}{The GRNN object generated by grnn.fit()}

\item{i}{The ith predictor in the GRNN}

\item{plot}{TRUE or FALSE to plot the partial effect}
}
\value{
A plot of the partial effect or a dataframe of the partial effect
}
\description{
The function \code{grnn.partial} derives the partial effect of a predictor used in a GRNN
by average-out values of the rest predictors.
}
\examples{
data(iris, package = "datasets")
Y <- ifelse(iris[, 5] == "setosa", 1, 0)
X <- scale(iris[, 1:4])
gnet <- grnn.fit(x = X, y = Y)
\dontrun{
grnn.partial(gnet, 1, plot = FALSE)
}
}
\seealso{
\code{\link{grnn.margin}}
}
