% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.R
\name{coerce-methods}
\alias{coerce-methods}
\alias{list2rmd_doc}
\alias{rmd_doc2list}
\alias{coerce,list,rmd_doc-method}
\title{Coercing lists and rmd_doc objects}
\usage{
list2rmd_doc(object)

rmd_doc2list(object)
}
\arguments{
\item{object}{Either a list or a \linkS4class{rmd_doc} object.}
}
\description{
Coercion of lists into \linkS4class{rmd_doc} objects and vice versa.

Objects of class \linkS4class{rmd_doc} can be created from lists or converted back
to lists. This is convenient for defining functions that manipulate the
content of such objects.
}
\examples{
## Create a document from a list
my_document <- list(
    title = "Sample Document",
    author = "Miguel Alavarez",
    output = "html_document",
    body = txt_body(
        "# Intro",
        "",
        "This is just an example."
    ))
my_document <- as(my_document, "rmd_doc")

## Convert back to a list
my_document <- as(my_document, "list")
}
