% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_clade}
\alias{get_clade}
\title{Extract the clade of a desired rank in a lineage}
\usage{
get_clade(lineage, rank = yatah::all_ranks, same = TRUE)
}
\arguments{
\item{lineage}{string. Vector of lineages.}

\item{rank}{The desired rank of the clade.}

\item{same}{logical. Does the lineage have the same depth? Default to \code{TRUE}.}
}
\value{
A string.
}
\description{
Extract the clade of a desired rank in a lineage
}
\examples{
lineage1 <- "k__Bacteria|p__Verrucomicrobia|c__Verrucomicrobiae"
lineage2 <- "k__Bacteria|p__Firmicutes|c__Clostridia"
get_clade(c(lineage1, lineage2), "phylum")
}
